<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

							do_action( 'quirky_action_page_content_end_text' );
							
							// Widgets area below the content
							quirky_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'quirky_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'quirky_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'quirky_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'quirky_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$quirky_body_style = quirky_get_theme_option( 'body_style' );
					$quirky_widgets_name = quirky_get_theme_option( 'widgets_below_page' );
					$quirky_show_widgets = ! quirky_is_off( $quirky_widgets_name ) && is_active_sidebar( $quirky_widgets_name );
					$quirky_show_related = quirky_is_single() && quirky_get_theme_option( 'related_position' ) == 'below_page';
					if ( $quirky_show_widgets || $quirky_show_related ) {
						if ( 'fullscreen' != $quirky_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $quirky_show_related ) {
							do_action( 'quirky_action_related_posts' );
						}

						// Widgets area below page content
						if ( $quirky_show_widgets ) {
							quirky_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $quirky_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'quirky_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'quirky_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! quirky_is_singular( 'post' ) && ! quirky_is_singular( 'attachment' ) ) || ! in_array ( quirky_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="quirky_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'quirky_action_before_footer' );

				// Footer
				$quirky_footer_type = quirky_get_theme_option( 'footer_type' );
				if ( 'custom' == $quirky_footer_type && ! quirky_is_layouts_available() ) {
					$quirky_footer_type = 'default';
				}
				get_template_part( apply_filters( 'quirky_filter_get_template_part', "templates/footer-" . sanitize_file_name( $quirky_footer_type ) ) );

				do_action( 'quirky_action_after_footer' );

			}
			?>

			<?php do_action( 'quirky_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'quirky_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'quirky_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>