<div class="front_page_section front_page_section_contacts<?php
	$quirky_scheme = quirky_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $quirky_scheme ) && ! quirky_is_inherit( $quirky_scheme ) ) {
		echo ' scheme_' . esc_attr( $quirky_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( quirky_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( quirky_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$quirky_css      = '';
		$quirky_bg_image = quirky_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $quirky_bg_image ) ) {
			$quirky_css .= 'background-image: url(' . esc_url( quirky_get_attachment_url( $quirky_bg_image ) ) . ');';
		}
		if ( ! empty( $quirky_css ) ) {
			echo ' style="' . esc_attr( $quirky_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$quirky_anchor_icon = quirky_get_theme_option( 'front_page_contacts_anchor_icon' );
	$quirky_anchor_text = quirky_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $quirky_anchor_icon ) || ! empty( $quirky_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $quirky_anchor_icon ) ? ' icon="' . esc_attr( $quirky_anchor_icon ) . '"' : '' )
									. ( ! empty( $quirky_anchor_text ) ? ' title="' . esc_attr( $quirky_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( quirky_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' quirky-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$quirky_css      = '';
			$quirky_bg_mask  = quirky_get_theme_option( 'front_page_contacts_bg_mask' );
			$quirky_bg_color_type = quirky_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $quirky_bg_color_type ) {
				$quirky_bg_color = quirky_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $quirky_bg_color_type ) {
				$quirky_bg_color = quirky_get_scheme_color( 'bg_color', $quirky_scheme );
			} else {
				$quirky_bg_color = '';
			}
			if ( ! empty( $quirky_bg_color ) && $quirky_bg_mask > 0 ) {
				$quirky_css .= 'background-color: ' . esc_attr(
					1 == $quirky_bg_mask ? $quirky_bg_color : quirky_hex2rgba( $quirky_bg_color, $quirky_bg_mask )
				) . ';';
			}
			if ( ! empty( $quirky_css ) ) {
				echo ' style="' . esc_attr( $quirky_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$quirky_caption     = quirky_get_theme_option( 'front_page_contacts_caption' );
			$quirky_description = quirky_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $quirky_caption ) || ! empty( $quirky_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $quirky_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $quirky_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $quirky_caption, 'quirky_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $quirky_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $quirky_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $quirky_description ), 'quirky_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$quirky_content = quirky_get_theme_option( 'front_page_contacts_content' );
			$quirky_layout  = quirky_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $quirky_layout && ( ! empty( $quirky_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $quirky_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $quirky_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $quirky_content, 'quirky_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $quirky_layout && ( ! empty( $quirky_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$quirky_sc = quirky_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $quirky_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $quirky_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					quirky_show_layout( do_shortcode( $quirky_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $quirky_layout && ( ! empty( $quirky_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
