<?php
$quirky_slider_sc = quirky_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $quirky_slider_sc ) && strpos( $quirky_slider_sc, '[' ) !== false && strpos( $quirky_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( quirky_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$quirky_anchor_icon = quirky_get_theme_option( 'front_page_title_anchor_icon' );
		$quirky_anchor_text = quirky_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $quirky_anchor_icon ) || ! empty( $quirky_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $quirky_anchor_icon ) ? ' icon="' . esc_attr( $quirky_anchor_icon ) . '"' : '' )
									. ( ! empty( $quirky_anchor_text ) ? ' title="' . esc_attr( $quirky_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $quirky_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$quirky_scheme = quirky_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $quirky_scheme ) && ! quirky_is_inherit( $quirky_scheme ) ) {
			echo ' scheme_' . esc_attr( $quirky_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( quirky_get_theme_option( 'front_page_title_paddings' ) );
		if ( quirky_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$quirky_css      = '';
		$quirky_bg_image = quirky_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $quirky_bg_image ) ) {
			$quirky_css .= 'background-image: url(' . esc_url( quirky_get_attachment_url( $quirky_bg_image ) ) . ');';
		}
		if ( ! empty( $quirky_css ) ) {
			echo ' style="' . esc_attr( $quirky_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$quirky_anchor_icon = quirky_get_theme_option( 'front_page_title_anchor_icon' );
		$quirky_anchor_text = quirky_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $quirky_anchor_icon ) || ! empty( $quirky_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $quirky_anchor_icon ) ? ' icon="' . esc_attr( $quirky_anchor_icon ) . '"' : '' )
									. ( ! empty( $quirky_anchor_text ) ? ' title="' . esc_attr( $quirky_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( quirky_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' quirky-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$quirky_css      = '';
			$quirky_bg_mask  = quirky_get_theme_option( 'front_page_title_bg_mask' );
			$quirky_bg_color_type = quirky_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $quirky_bg_color_type ) {
				$quirky_bg_color = quirky_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $quirky_bg_color_type ) {
				$quirky_bg_color = quirky_get_scheme_color( 'bg_color', $quirky_scheme );
			} else {
				$quirky_bg_color = '';
			}
			if ( ! empty( $quirky_bg_color ) && $quirky_bg_mask > 0 ) {
				$quirky_css .= 'background-color: ' . esc_attr(
					1 == $quirky_bg_mask ? $quirky_bg_color : quirky_hex2rgba( $quirky_bg_color, $quirky_bg_mask )
				) . ';';
			}
			if ( ! empty( $quirky_css ) ) {
				echo ' style="' . esc_attr( $quirky_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$quirky_caption = quirky_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $quirky_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $quirky_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $quirky_caption, 'quirky_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$quirky_description = quirky_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $quirky_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $quirky_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $quirky_description ), 'quirky_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( quirky_get_theme_option( 'front_page_title_button1_link' ) != '' || quirky_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						quirky_show_layout( quirky_customizer_partial_refresh_front_page_title_button1_link() );
						quirky_show_layout( quirky_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
