<?php
$quirky_woocommerce_sc = quirky_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $quirky_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$quirky_scheme = quirky_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $quirky_scheme ) && ! quirky_is_inherit( $quirky_scheme ) ) {
			echo ' scheme_' . esc_attr( $quirky_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( quirky_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( quirky_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$quirky_css      = '';
			$quirky_bg_image = quirky_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $quirky_bg_image ) ) {
				$quirky_css .= 'background-image: url(' . esc_url( quirky_get_attachment_url( $quirky_bg_image ) ) . ');';
			}
			if ( ! empty( $quirky_css ) ) {
				echo ' style="' . esc_attr( $quirky_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$quirky_anchor_icon = quirky_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$quirky_anchor_text = quirky_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $quirky_anchor_icon ) || ! empty( $quirky_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $quirky_anchor_icon ) ? ' icon="' . esc_attr( $quirky_anchor_icon ) . '"' : '' )
											. ( ! empty( $quirky_anchor_text ) ? ' title="' . esc_attr( $quirky_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( quirky_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' quirky-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$quirky_css      = '';
				$quirky_bg_mask  = quirky_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$quirky_bg_color_type = quirky_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $quirky_bg_color_type ) {
					$quirky_bg_color = quirky_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $quirky_bg_color_type ) {
					$quirky_bg_color = quirky_get_scheme_color( 'bg_color', $quirky_scheme );
				} else {
					$quirky_bg_color = '';
				}
				if ( ! empty( $quirky_bg_color ) && $quirky_bg_mask > 0 ) {
					$quirky_css .= 'background-color: ' . esc_attr(
						1 == $quirky_bg_mask ? $quirky_bg_color : quirky_hex2rgba( $quirky_bg_color, $quirky_bg_mask )
					) . ';';
				}
				if ( ! empty( $quirky_css ) ) {
					echo ' style="' . esc_attr( $quirky_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$quirky_caption     = quirky_get_theme_option( 'front_page_woocommerce_caption' );
				$quirky_description = quirky_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $quirky_caption ) || ! empty( $quirky_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $quirky_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $quirky_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $quirky_caption, 'quirky_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $quirky_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $quirky_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $quirky_description ), 'quirky_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $quirky_woocommerce_sc ) {
						$quirky_woocommerce_sc_ids      = quirky_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$quirky_woocommerce_sc_per_page = count( explode( ',', $quirky_woocommerce_sc_ids ) );
					} else {
						$quirky_woocommerce_sc_per_page = max( 1, (int) quirky_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$quirky_woocommerce_sc_columns = max( 1, min( $quirky_woocommerce_sc_per_page, (int) quirky_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$quirky_woocommerce_sc}"
										. ( 'products' == $quirky_woocommerce_sc
												? ' ids="' . esc_attr( $quirky_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $quirky_woocommerce_sc
												? ' category="' . esc_attr( quirky_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $quirky_woocommerce_sc
												? ' orderby="' . esc_attr( quirky_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( quirky_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $quirky_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $quirky_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
