<?php
/**
 * The Header: Logo and main menu
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( quirky_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'quirky_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'quirky_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('quirky_action_body_wrap_attributes'); ?>>

		<?php do_action( 'quirky_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'quirky_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('quirky_action_page_wrap_attributes'); ?>>

			<?php do_action( 'quirky_action_page_wrap_start' ); ?>

			<?php
			$quirky_full_post_loading = ( quirky_is_singular( 'post' ) || quirky_is_singular( 'attachment' ) ) && quirky_get_value_gp( 'action' ) == 'full_post_loading';
			$quirky_prev_post_loading = ( quirky_is_singular( 'post' ) || quirky_is_singular( 'attachment' ) ) && quirky_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $quirky_full_post_loading && ! $quirky_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="quirky_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'quirky_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'quirky' ); ?></a>
				<?php if ( quirky_sidebar_present() ) { ?>
				<a class="quirky_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'quirky_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'quirky' ); ?></a>
				<?php } ?>
				<a class="quirky_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'quirky_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'quirky' ); ?></a>

				<?php
				do_action( 'quirky_action_before_header' );

				// Header
				$quirky_header_type = quirky_get_theme_option( 'header_type' );
				if ( 'custom' == $quirky_header_type && ! quirky_is_layouts_available() ) {
					$quirky_header_type = 'default';
				}
				get_template_part( apply_filters( 'quirky_filter_get_template_part', "templates/header-" . sanitize_file_name( $quirky_header_type ) ) );

				// Side menu
				if ( in_array( quirky_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'quirky_action_after_header' );

			}
			?>

			<?php do_action( 'quirky_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( quirky_is_off( quirky_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $quirky_header_type ) ) {
						$quirky_header_type = quirky_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $quirky_header_type && quirky_is_layouts_available() ) {
						$quirky_header_id = quirky_get_custom_header_id();
						if ( $quirky_header_id > 0 ) {
							$quirky_header_meta = quirky_get_custom_layout_meta( $quirky_header_id );
							if ( ! empty( $quirky_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$quirky_footer_type = quirky_get_theme_option( 'footer_type' );
					if ( 'custom' == $quirky_footer_type && quirky_is_layouts_available() ) {
						$quirky_footer_id = quirky_get_custom_footer_id();
						if ( $quirky_footer_id ) {
							$quirky_footer_meta = quirky_get_custom_layout_meta( $quirky_footer_id );
							if ( ! empty( $quirky_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'quirky_action_page_content_wrap_class', $quirky_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'quirky_filter_is_prev_post_loading', $quirky_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( quirky_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'quirky_action_page_content_wrap_data', $quirky_prev_post_loading );
			?>>
				<?php
				do_action( 'quirky_action_page_content_wrap', $quirky_full_post_loading || $quirky_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'quirky_filter_single_post_header', quirky_is_singular( 'post' ) || quirky_is_singular( 'attachment' ) ) ) {
					if ( $quirky_prev_post_loading ) {
						if ( quirky_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'quirky_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$quirky_path = apply_filters( 'quirky_filter_get_template_part', 'templates/single-styles/' . quirky_get_theme_option( 'single_style' ) );
					if ( quirky_get_file_dir( $quirky_path . '.php' ) != '' ) {
						get_template_part( $quirky_path );
					}
				}

				// Widgets area above page
				$quirky_body_style   = quirky_get_theme_option( 'body_style' );
				$quirky_widgets_name = quirky_get_theme_option( 'widgets_above_page' );
				$quirky_show_widgets = ! quirky_is_off( $quirky_widgets_name ) && is_active_sidebar( $quirky_widgets_name );
				if ( $quirky_show_widgets ) {
					if ( 'fullscreen' != $quirky_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					quirky_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $quirky_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'quirky_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $quirky_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'quirky_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'quirky_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="quirky_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( quirky_is_singular( 'post' ) || quirky_is_singular( 'attachment' ) )
							&& $quirky_prev_post_loading 
							&& quirky_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'quirky_action_between_posts' );
						}

						// Widgets area above content
						quirky_create_widgets_area( 'widgets_above_content' );

						do_action( 'quirky_action_page_content_start_text' );
