<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

$quirky_template = apply_filters( 'quirky_filter_get_template_part', quirky_blog_archive_get_template() );

if ( ! empty( $quirky_template ) && 'index' != $quirky_template ) {

	get_template_part( $quirky_template );

} else {

	quirky_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$quirky_stickies   = is_home()
								|| ( in_array( quirky_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) quirky_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$quirky_post_type  = quirky_get_theme_option( 'post_type' );
		$quirky_args       = array(
								'blog_style'     => quirky_get_theme_option( 'blog_style' ),
								'post_type'      => $quirky_post_type,
								'taxonomy'       => quirky_get_post_type_taxonomy( $quirky_post_type ),
								'parent_cat'     => quirky_get_theme_option( 'parent_cat' ),
								'posts_per_page' => quirky_get_theme_option( 'posts_per_page' ),
								'sticky'         => quirky_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $quirky_stickies )
															&& count( $quirky_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		quirky_blog_archive_start();

		do_action( 'quirky_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'quirky_action_before_page_author' );
			get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'quirky_action_after_page_author' );
		}

		if ( quirky_get_theme_option( 'show_filters' ) ) {
			do_action( 'quirky_action_before_page_filters' );
			quirky_show_filters( $quirky_args );
			do_action( 'quirky_action_after_page_filters' );
		} else {
			do_action( 'quirky_action_before_page_posts' );
			quirky_show_posts( array_merge( $quirky_args, array( 'cat' => $quirky_args['parent_cat'] ) ) );
			do_action( 'quirky_action_after_page_posts' );
		}

		do_action( 'quirky_action_blog_archive_end' );

		quirky_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
