<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

if ( quirky_sidebar_present() ) {
	
	$quirky_sidebar_type = quirky_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $quirky_sidebar_type && ! quirky_is_layouts_available() ) {
		$quirky_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $quirky_sidebar_type ) {
		// Default sidebar with widgets
		$quirky_sidebar_name = quirky_get_theme_option( 'sidebar_widgets' );
		quirky_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $quirky_sidebar_name ) ) {
			dynamic_sidebar( $quirky_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$quirky_sidebar_id = quirky_get_custom_sidebar_id();
		do_action( 'quirky_action_show_layout', $quirky_sidebar_id );
	}
	$quirky_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $quirky_out ) ) {
		$quirky_sidebar_position    = quirky_get_theme_option( 'sidebar_position' );
		$quirky_sidebar_position_ss = quirky_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $quirky_sidebar_position );
			echo ' sidebar_' . esc_attr( $quirky_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $quirky_sidebar_type );

			$quirky_sidebar_scheme = apply_filters( 'quirky_filter_sidebar_scheme', quirky_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $quirky_sidebar_scheme ) && ! quirky_is_inherit( $quirky_sidebar_scheme ) && 'custom' != $quirky_sidebar_type ) {
				echo ' scheme_' . esc_attr( $quirky_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="quirky_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'quirky_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $quirky_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$quirky_title = apply_filters( 'quirky_filter_sidebar_control_title', 'float' == $quirky_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'quirky' ) : '' );
				$quirky_text  = apply_filters( 'quirky_filter_sidebar_control_text', 'above' == $quirky_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'quirky' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $quirky_title ); ?>"><?php echo esc_html( $quirky_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'quirky_action_before_sidebar', 'sidebar' );
				quirky_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $quirky_out ) );
				do_action( 'quirky_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'quirky_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
