<?php
/**
 * The template to display single post
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

// Full post loading
$full_post_loading          = quirky_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = quirky_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = quirky_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$quirky_related_position   = quirky_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$quirky_posts_navigation   = quirky_get_theme_option( 'posts_navigation' );
$quirky_prev_post          = false;
$quirky_prev_post_same_cat = quirky_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( quirky_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	quirky_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'quirky_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $quirky_posts_navigation ) {
		$quirky_prev_post = get_previous_post( $quirky_prev_post_same_cat );  // Get post from same category
		if ( ! $quirky_prev_post && $quirky_prev_post_same_cat ) {
			$quirky_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $quirky_prev_post ) {
			$quirky_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $quirky_prev_post ) ) {
		quirky_sc_layouts_showed( 'featured', false );
		quirky_sc_layouts_showed( 'title', false );
		quirky_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $quirky_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/content', 'single-' . quirky_get_theme_option( 'single_style' ) ), 'single-' . quirky_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $quirky_related_position, 'inside' ) === 0 ) {
		$quirky_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'quirky_action_related_posts' );
		$quirky_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $quirky_related_content ) ) {
			$quirky_related_position_inside = max( 0, min( 9, quirky_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $quirky_related_position_inside ) {
				$quirky_related_position_inside = mt_rand( 1, 9 );
			}

			$quirky_p_number         = 0;
			$quirky_related_inserted = false;
			$quirky_in_block         = false;
			$quirky_content_start    = strpos( $quirky_content, '<div class="post_content' );
			$quirky_content_end      = strrpos( $quirky_content, '</div>' );

			for ( $i = max( 0, $quirky_content_start ); $i < min( strlen( $quirky_content ) - 3, $quirky_content_end ); $i++ ) {
				if ( $quirky_content[ $i ] != '<' ) {
					continue;
				}
				if ( $quirky_in_block ) {
					if ( strtolower( substr( $quirky_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$quirky_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $quirky_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $quirky_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$quirky_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $quirky_content[ $i + 1 ] && in_array( $quirky_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$quirky_p_number++;
					if ( $quirky_related_position_inside == $quirky_p_number ) {
						$quirky_related_inserted = true;
						$quirky_content = ( $i > 0 ? substr( $quirky_content, 0, $i ) : '' )
											. $quirky_related_content
											. substr( $quirky_content, $i );
					}
				}
			}
			if ( ! $quirky_related_inserted ) {
				if ( $quirky_content_end > 0 ) {
					$quirky_content = substr( $quirky_content, 0, $quirky_content_end ) . $quirky_related_content . substr( $quirky_content, $quirky_content_end );
				} else {
					$quirky_content .= $quirky_related_content;
				}
			}
		}

		quirky_show_layout( $quirky_content );
	}

	// Comments
	do_action( 'quirky_action_before_comments' );
	comments_template();
	do_action( 'quirky_action_after_comments' );

	// Related posts
	if ( 'below_content' == $quirky_related_position
		&& ( 'scroll' != $quirky_posts_navigation || quirky_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || quirky_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'quirky_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $quirky_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $quirky_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $quirky_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $quirky_prev_post ) ); ?>"
			<?php do_action( 'quirky_action_nav_links_single_scroll_data', $quirky_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
