<?php

/* Ultimate Auction for WooCommerce support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'quirky_ultimate_woocommerce_auction_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'quirky_ultimate_woocommerce_auction_theme_setup9', 9 );
    function quirky_ultimate_woocommerce_auction_theme_setup9() {
        add_action( 'wp_enqueue_scripts', 'quirky_ultimate_woocommerce_auction_frontend_scripts', 1100 );
        add_action( 'wp_enqueue_scripts', 'quirky_ultimate_woocommerce_auction_responsive_styles', 2000 );
        add_filter('quirky_filter_merge_styles', 'quirky_ultimate_woocommerce_auction_merge_styles');
        add_filter( 'quirky_filter_merge_styles_responsive', 'quirky_ultimate_woocommerce_auction_merge_styles_responsive' );
        if ( is_admin() ) {
            add_filter( 'quirky_filter_tgmpa_required_plugins', 'quirky_ultimate_woocommerce_auction_tgmpa_required_plugins' );
        }
    }
}
// Filter to add in the required plugins list
if ( ! function_exists( 'quirky_ultimate_woocommerce_auction_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('quirky_filter_tgmpa_required_plugins',	'quirky_ultimate_woocommerce_auction_tgmpa_required_plugins');
    function quirky_ultimate_woocommerce_auction_tgmpa_required_plugins( $list = array() ) {
        if ( quirky_storage_isset( 'required_plugins', 'ultimate-woocommerce-auction' ) && quirky_storage_get_array( 'required_plugins', 'ultimate-woocommerce-auction', 'install' ) !== false ) {
            $list[] = array(
                'name'     => quirky_storage_get_array( 'required_plugins', 'ultimate-woocommerce-auction', 'title' ),
                'slug'     => 'ultimate-woocommerce-auction',
                'required' => false,
            );
        }
        return $list;
    }
}
// Check if plugin installed and activated
if ( ! function_exists( 'quirky_exists_ultimate_woocommerce_auction' ) ) {
    function quirky_exists_ultimate_woocommerce_auction() {
        return  class_exists( 'Ultimate_WooCommerce_Auction_Free' );
    }
}
// Enqueue styles for frontend
if ( ! function_exists( 'quirky_ultimate_woocommerce_auction_frontend_scripts' ) ) {
    //Handler of the add_action( 'wp_enqueue_scripts', 'quirky_ultimate_woocommerce_auction_frontend_scripts', 1100 );
    function quirky_ultimate_woocommerce_auction_frontend_scripts() {
        if ( quirky_is_on( quirky_get_theme_option( 'debug_mode' ) ) ) {
            $quirky_url = quirky_get_file_url( 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction.css' );
            if ( '' != $quirky_url ) {
                wp_enqueue_style( 'quirky-ultimate-woocommerce-auction', $quirky_url, array(), null );
            }
        }
    }
}
// Enqueue responsive styles for frontend
if ( ! function_exists( 'quirky_ultimate_woocommerce_auction_responsive_styles' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'quirky_ultimate_woocommerce_auction_responsive_styles', 2000 );
	function quirky_ultimate_woocommerce_auction_responsive_styles() {
		if ( quirky_is_on( quirky_get_theme_option( 'debug_mode' ) ) ) {
			$quirky_url = quirky_get_file_url( 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction-responsive.css' );
			if ( '' != $quirky_url ) {
				wp_enqueue_style( 'quirky-ultimate-woocommerce-auction-responsive', $quirky_url, array(), null, quirky_media_for_load_css_responsive( 'ultimate-woocommerce-auction' ) );
			}
		}
	}
}
// Merge custom styles
if ( ! function_exists( 'quirky_ultimate_woocommerce_auction_merge_styles' ) ) {
    //Handler of the add_filter('quirky_filter_merge_styles', 'quirky_ultimate_woocommerce_auction_merge_styles');
    function quirky_ultimate_woocommerce_auction_merge_styles( $list ) {
        $list[ 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction.css' ] = true;
        return $list;
    }
}
// Merge responsive styles
if ( ! function_exists( 'quirky_ultimate_woocommerce_auction_merge_styles_responsive' ) ) {
	//Handler of the add_filter('quirky_filter_merge_styles_responsive', 'quirky_ultimate_woocommerce_auction_merge_styles_responsive');
	function quirky_ultimate_woocommerce_auction_merge_styles_responsive( $list ) {
		$list[ 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction-responsive.css' ] = true;
		return $list;
	}
}
// Add plugin-specific colors and fonts to the custom CSS
if ( quirky_exists_ultimate_woocommerce_auction() ) {
    require_once quirky_get_file_dir( 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction-style.php' );
}
// Check plugin in the required plugins
if ( !function_exists( 'quirky_ultimate_woocommerce_auction_importer_required_plugins' ) ) {
	add_filter( 'trx_addons_filter_importer_required_plugins',	'quirky_ultimate_woocommerce_auction_importer_required_plugins', 10, 2 );
	function quirky_ultimate_woocommerce_auction_importer_required_plugins($not_installed='', $list='') {
		if (strpos($list, 'ultimate-woocommerce-auction')!==false && !quirky_exists_ultimate_woocommerce_auction() )
			$not_installed .= '<br>' . esc_html__('Ultimate Auction for WooCommerce', 'quirky');
		return $not_installed;
	}
}
// Set plugin's specific importer options
if ( !function_exists( 'quirky_ultimate_woocommerce_auction_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options',	'quirky_ultimate_woocommerce_auction_importer_set_options' );
	function quirky_ultimate_woocommerce_auction_importer_set_options($options=array()) {
		if ( quirky_exists_ultimate_woocommerce_auction() && in_array('ultimate-woocommerce-auction', $options['required_plugins']) ) {
			$options['additional_options'][] = 'woo_ua_%';
			$options['additional_options'][] = 'uwa_%';
		}
		return $options;
	}
}