<?php
/* WCFM – Frontend Manager for WooCommerce support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'quirky_wc_frontend_manager_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'quirky_wc_frontend_manager_theme_setup9', 9 );
    function quirky_wc_frontend_manager_theme_setup9() {
        if ( quirky_exists_wc_frontend_manager() ) {
            add_action( 'wp_enqueue_scripts', 'quirky_wc_frontend_manager_frontend_scripts', 1100 );
            add_action( 'wp_enqueue_scripts', 'quirky_wc_frontend_manager_responsive_styles', 2000 );
            add_filter('quirky_filter_merge_styles', 'quirky_wc_frontend_manager_merge_styles');
            add_filter( 'quirky_filter_merge_styles_responsive', 'quirky_wc_frontend_manager_merge_styles_responsive' );
            add_filter( 'quirky_filter_merge_scripts', 'quirky_wc_frontend_manager_merge_scripts' );
        }
        if ( is_admin() ) {
            add_filter( 'quirky_filter_tgmpa_required_plugins', 'quirky_wc_frontend_manager_tgmpa_required_plugins' );
        }
    }
}
// Filter to add in the required plugins list
if ( ! function_exists( 'quirky_wc_frontend_manager_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('quirky_filter_tgmpa_required_plugins',	'quirky_wc_frontend_manager_tgmpa_required_plugins');
    function quirky_wc_frontend_manager_tgmpa_required_plugins( $list = array() ) {
        if ( quirky_storage_isset( 'required_plugins', 'wc-frontend-manager' ) && quirky_storage_get_array( 'required_plugins', 'wc-frontend-manager', 'install' ) !== false ) {
            $list[] = array(
                'name'     => quirky_storage_get_array( 'required_plugins', 'wc-frontend-manager', 'title' ),
                'slug'     => 'wc-frontend-manager',
                'required' => false,
            );
        }
        return $list;
    }
}
// Check if plugin installed and activated
if ( ! function_exists( 'quirky_exists_wc_frontend_manager' ) ) {
    function quirky_exists_wc_frontend_manager() {
        return class_exists( 'WCFM' );
    }
}
// Enqueue styles for frontend
if ( ! function_exists( 'quirky_wc_frontend_manager_frontend_scripts' ) ) {
    //Handler of the add_action( 'wp_enqueue_scripts', 'quirky_wc_frontend_manager_frontend_scripts', 1100 );
    function quirky_wc_frontend_manager_frontend_scripts() {
        if ( quirky_is_on( quirky_get_theme_option( 'debug_mode' ) ) ) {
            $quirky_url = quirky_get_file_url( 'plugins/wc-frontend-manager/wc-frontend-manager.css' );
            if ( '' != $quirky_url ) {
                wp_enqueue_style( 'quirky-wc-frontend-manager', $quirky_url, array(), null );
            }
            $quirky_url = quirky_get_file_url( 'plugins/wc-frontend-manager/wc-frontend-manager.js' );
            if ( '' != $quirky_url ) {
                wp_enqueue_script( 'quirky-wc-frontend-manager', $quirky_url, array( 'jquery' ), null, true );
            }
        }
    }
}
// Enqueue responsive styles for frontend
if ( ! function_exists( 'quirky_wc_frontend_manager_responsive_styles' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'quirky_wc_frontend_manager_responsive_styles', 2000 );
	function quirky_wc_frontend_manager_responsive_styles() {
		if ( quirky_is_on( quirky_get_theme_option( 'debug_mode' ) ) ) {
			$quirky_url = quirky_get_file_url( 'plugins/wc-frontend-manager/wc-frontend-manager-responsive.css' );
			if ( '' != $quirky_url ) {
				wp_enqueue_style( 'quirky-wc-frontend-manager-responsive', $quirky_url, array(), null, quirky_media_for_load_css_responsive( 'wc-frontend-manager' ) );
			}
		}
	}
}
// Merge custom styles
if ( ! function_exists( 'quirky_wc_frontend_manager_merge_styles' ) ) {
    //Handler of the add_filter('quirky_filter_merge_styles', 'quirky_wc_frontend_manager_merge_styles');
    function quirky_wc_frontend_manager_merge_styles( $list ) {
        $list[ 'plugins/wc-frontend-manager/wc-frontend-manager.css' ] = true;
        return $list;
    }
}
// Merge responsive styles
if ( ! function_exists( 'quirky_wc_frontend_manager_merge_styles_responsive' ) ) {
	//Handler of the add_filter('quirky_filter_merge_styles_responsive', 'quirky_wc_frontend_manager_merge_styles_responsive');
	function quirky_wc_frontend_manager_merge_styles_responsive( $list ) {
		$list[ 'plugins/wc-frontend-manager/wc-frontend-manager-responsive.css' ] = true;
		return $list;
	}
}
// Merge custom scripts
if ( ! function_exists( 'quirky_wc_frontend_manager_merge_scripts' ) ) {
    //Handler of the add_filter('quirky_filter_merge_scripts', 'quirky_wc_frontend_manager_merge_scripts');
    function quirky_wc_frontend_manager_merge_scripts( $list ) {
        $list[ 'plugins/wc-frontend-manager/wc-frontend-manager.js' ] = true;
        return $list;
    }
}
// Add plugin-specific colors and fonts to the custom CSS
if ( quirky_exists_wc_frontend_manager() ) {
    require_once quirky_get_file_dir( 'plugins/wc-frontend-manager/wc-frontend-manager-style.php' );
}
// Check plugin in the required plugins
if ( !function_exists( 'quirky_wc_frontend_manager_importer_required_plugins' ) ) {
	add_filter( 'trx_addons_filter_importer_required_plugins',	'quirky_wc_frontend_manager_importer_required_plugins', 10, 2 );
	function quirky_wc_frontend_manager_importer_required_plugins($not_installed='', $list='') {
		if (strpos($list, 'wc-frontend-manager')!==false && !quirky_exists_wc_frontend_manager() )
			$not_installed .= '<br>' . esc_html__('WCFM – Frontend Manager', 'quirky');
		return $not_installed;
	}
}
// Set plugin's specific importer options
if ( !function_exists( 'quirky_wc_frontend_manager_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options',	'quirky_wc_frontend_manager_importer_set_options' );
	function quirky_wc_frontend_manager_importer_set_options($options=array()) {
		if ( quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $options['required_plugins']) ) {
			$options['additional_options'][]	= 'wcfm_%';
            if (is_array($options['files']) && count($options['files']) > 0) {
                foreach ($options['files'] as $k => $v) {
                    $options['files'][$k]['file_with_wc-frontend-manager'] = str_replace('name.ext', 'wc-frontend-manager.txt', $v['file_with_']);
                }
            }
		}
		return $options;
	}
}
// Prevent import plugin's specific options if plugin is not installed
if ( !function_exists( 'quirky_wc_frontend_manager_importer_check_options' ) ) {
    add_filter( 'trx_addons_filter_import_theme_options', 'quirky_wc_frontend_manager_importer_check_options', 10, 4 );
    function quirky_wc_frontend_manager_importer_check_options($allow, $k, $v, $options) {
        if ($allow && (strpos($k, 'wcfm_')===0) ) {
            $allow = quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $options['required_plugins']);
        }
        return $allow;
    }
}
// Add checkbox to the one-click importer
if ( !function_exists( 'quirky_wc_frontend_manager_importer_show_params' ) ) {
    add_action( 'trx_addons_action_importer_params', 'quirky_wc_frontend_manager_importer_show_params', 10, 1 );
    function quirky_wc_frontend_manager_importer_show_params($importer) {
        if ( quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $importer->options['required_plugins']) ) {
            $importer->show_importer_params(array(
                'slug' => 'wc-frontend-manager',
                'title' => esc_html__('Import WCFM – Frontend Manager', 'quirky'),
                'part' => 0
            ));
        }
    }
}
// Import posts
if ( !function_exists( 'quirky_wc_frontend_manager_importer_import' ) ) {
    add_action( 'trx_addons_action_importer_import', 'quirky_wc_frontend_manager_importer_import', 10, 2 );
    function quirky_wc_frontend_manager_importer_import($importer, $action) {
        if ( quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $importer->options['required_plugins']) ) {
            if ( $action == 'import_wc-frontend-manager' ) {
                $importer->response['start_from_id'] = 0;
                $importer->import_dump('wc-frontend-manager', esc_html__('WCFM – Frontend Manager', 'quirky'));
            }
        }
    }
}
// Display import progress
if ( !function_exists( 'quirky_wc_frontend_manager_importer_import_fields' ) ) {
    add_action( 'trx_addons_action_importer_import_fields',	'quirky_wc_frontend_manager_importer_import_fields', 10, 1 );
    function quirky_wc_frontend_manager_importer_import_fields($importer) {
        if ( quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $importer->options['required_plugins']) ) {
            $importer->show_importer_fields(array(
                    'slug'=>'wc-frontend-manager',
                    'title' => esc_html__('WCFM – Frontend Manager', 'quirky')
                )
            );
        }
    }
}
// Export posts
if ( !function_exists( 'quirky_wc_frontend_manager_importer_export' ) ) {
    add_action( 'trx_addons_action_importer_export',	'quirky_wc_frontend_manager_importer_export', 10, 1 );
    function quirky_wc_frontend_manager_importer_export($importer) {
        if ( quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $importer->options['required_plugins']) ) {
            trx_addons_fpc($importer->export_file_dir('wc-frontend-manager.txt'), serialize( array(
                    "wcfm_daily_analysis"			          	=> $importer->export_dump("wcfm_daily_analysis"),
                    "wcfm_detailed_analysis"	                => $importer->export_dump("wcfm_detailed_analysis"),
                    "wcfm_enquiries"					        => $importer->export_dump("wcfm_enquiries"),
                    "wcfm_enquiries_meta"				        => $importer->export_dump("wcfm_enquiries_meta"),
                    "wcfm_enquiries_response"					=> $importer->export_dump("wcfm_enquiries_response"),
                    "wcfm_enquiries_response_meta"				=> $importer->export_dump("wcfm_enquiries_response_meta"),
                    "wcfm_fbc_chat_rows"						=> $importer->export_dump("wcfm_fbc_chat_rows"),
                    "wcfm_fbc_chat_sessions"					=> $importer->export_dump("wcfm_fbc_chat_sessions"),
                    "wcfm_fbc_chat_visitors"					=> $importer->export_dump("wcfm_fbc_chat_visitors"),
                    "wcfm_fbc_offline_messages"				    => $importer->export_dump("wcfm_fbc_offline_messages"),
                    "wcfm_following_followers"					=> $importer->export_dump("wcfm_following_followers"),
                    "wcfm_marketplace_orders"					=> $importer->export_dump("wcfm_marketplace_orders"),
                    "wcfm_marketplace_orders_meta"				=> $importer->export_dump("wcfm_marketplace_orders_meta"),
                    "wcfm_marketplace_product_multivendor"		=> $importer->export_dump("wcfm_marketplace_product_multivendor"),
                    "wcfm_marketplace_refund_request"			=> $importer->export_dump("wcfm_marketplace_refund_request"),
                    "wcfm_marketplace_refund_request_meta"		=> $importer->export_dump("wcfm_marketplace_refund_request_meta"),
                    "wcfm_marketplace_reverse_withdrawal"		=> $importer->export_dump("wcfm_marketplace_reverse_withdrawal"),
                    "wcfm_marketplace_reverse_withdrawal_meta"  => $importer->export_dump("wcfm_marketplace_reverse_withdrawal_meta"),
                    "wcfm_marketplace_reviews"					=> $importer->export_dump("wcfm_marketplace_reviews"),
                    "wcfm_marketplace_reviews_response"			=> $importer->export_dump("wcfm_marketplace_reviews_response"),
                    "wcfm_marketplace_reviews_response_meta"	=> $importer->export_dump("wcfm_marketplace_reviews_response_meta"),
                    "wcfm_marketplace_review_rating_meta"		=> $importer->export_dump("wcfm_marketplace_review_rating_meta"),
                    "wcfm_marketplace_shipping_zone_locations"	=> $importer->export_dump("wcfm_marketplace_shipping_zone_locations"),
                    "wcfm_marketplace_shipping_zone_methods"	=> $importer->export_dump("wcfm_marketplace_shipping_zone_methods"),
                    "wcfm_marketplace_store_taxonomies"			=> $importer->export_dump("wcfm_marketplace_store_taxonomies"),
                    "wcfm_marketplace_vendor_ledger"			=> $importer->export_dump("wcfm_marketplace_vendor_ledger"),
                    "wcfm_marketplace_withdraw_request"			=> $importer->export_dump("wcfm_marketplace_withdraw_request"),
                    "wcfm_marketplace_withdraw_request_meta"	=> $importer->export_dump("wcfm_marketplace_withdraw_request_meta"),
                    "wcfm_membership_subscription"			    => $importer->export_dump("wcfm_membership_subscription"),
                    "wcfm_messages"			                    => $importer->export_dump("wcfm_messages"),
                    "wcfm_messages_modifier"			        => $importer->export_dump("wcfm_messages_modifier"),
                    "wcfm_messages_stat"			            => $importer->export_dump("wcfm_messages_stat"),
                    "wcfm_support"			                    => $importer->export_dump("wcfm_support"),
                    "wcfm_support_meta"			                => $importer->export_dump("wcfm_support_meta"),
                    "wcfm_support_response"			            => $importer->export_dump("wcfm_support_response"),
                    "wcfm_support_response_meta"			    => $importer->export_dump("wcfm_support_response_meta")
                ) )
            );
        }
    }
}
// Display exported data in the fields
if ( !function_exists( 'quirky_wc_frontend_manager_importer_export_fields' ) ) {
    add_action( 'trx_addons_action_importer_export_fields',	'quirky_wc_frontend_manager_importer_export_fields', 10, 1 );
    function quirky_wc_frontend_manager_importer_export_fields($importer) {
        if ( quirky_exists_wc_frontend_manager() && in_array('wc-frontend-manager', $importer->options['required_plugins']) ) {
            $importer->show_exporter_fields(array(
                    'slug'	=> 'wc-frontend-manager',
                    'title' => esc_html__('WCFM – Frontend Manager', 'quirky')
                )
            );
        }
    }
}


