<?php

/* WCFM Marketplace – Best Multivendor Marketplace for WooCommerce support functions
------------------------------------------------------------------------------- */

// add/remove Theme Options elements
if ( ! function_exists( 'quirky_wc_multivendor_marketplace_wp' ) ) {
    add_action( 'wp', 'quirky_wc_multivendor_marketplace_wp' );
    function quirky_wc_multivendor_marketplace_wp() {
        if ( quirky_exists_wc_frontend_manager() && quirky_exists_wc_multivendor_marketplace() ) {
            if ( wcfmmp_is_store_page() ) {
                remove_action('single_product_archive_thumbnail_size', 'quirky_woocommerce_single_product_archive_thumbnail_size');
            }
        }
    }
}
// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'quirky_wc_multivendor_marketplace_theme_setup3' ) ) {
    add_action( 'after_setup_theme', 'quirky_wc_multivendor_marketplace_theme_setup3', 3 );
    function quirky_wc_multivendor_marketplace_theme_setup3() {
        if ( quirky_exists_wc_frontend_manager() && quirky_exists_wc_multivendor_marketplace() ) {
            // Section 'WCFM Marketplace'
            quirky_storage_merge_array(
                'options', '', array_merge(
                    array(
                        'wc-multivendor-marketplace' => array(
                            'title' => esc_html__( 'WCFM Marketplace', 'quirky' ),
                            'desc'  => wp_kses_data( __( 'Select parameters to display the WCFM Marketplace pages', 'quirky' ) ),
                            'icon'  => 'icon-globe',
                            'type'  => 'section',
                        ),
                    ),
                     array(
                         'single_store_info'        => array(
                             'title' => esc_html__( 'Single Store', 'quirky' ),
                             'desc'  => '',
                             'type'  => 'info',
                         ),

                        'blog_columns_single_store'   => array(
                            'title'      => esc_html__( 'Grid columns', 'quirky' ),
                            'desc'       => wp_kses_data( __( 'How many columns should be used for the single store products (from 2 to 4)?', 'quirky' ) ),
                            'dependency' => array(
                                'shop_mode' => array( 'thumbs' ),
                            ),
                            'std'        => 2,
                            'options'    => quirky_get_list_range( 2, 4 ),
                            'type'       => 'select',
                        ),
                    ),
                    quirky_options_get_list_cpt_options( 'store', esc_html__( 'WCFM Marketplace', 'quirky' ) )
                )
            );
        }
    }
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'quirky_wc_multivendor_marketplace_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'quirky_wc_multivendor_marketplace_theme_setup9', 9 );
    function quirky_wc_multivendor_marketplace_theme_setup9() {
        if ( quirky_exists_wc_frontend_manager() && quirky_exists_wc_multivendor_marketplace() ) {
            add_filter( 'quirky_filter_detect_blog_mode', 'quirky_wc_multivendor_marketplace_detect_blog_mode' );
            add_filter( 'quirky_filter_is_single', 'quirky_wc_multivendor_marketplace_detect_single_post' );
            add_filter( 'woocommerce_post_class', 'quirky_wc_multivendor_marketplace_loop_shop_columns_class' );
            add_filter( 'product_cat_class', 'quirky_wc_multivendor_marketplace_loop_shop_columns_class', 10, 3 );    
        }
        if ( is_admin() ) {
            add_filter( 'quirky_filter_tgmpa_required_plugins', 'quirky_wc_multivendor_marketplace_tgmpa_required_plugins' );
        }
    }
}
// Filter to add in the required plugins list
if ( ! function_exists( 'quirky_wc_multivendor_marketplace_tgmpa_required_plugins' ) ) {
    //Handler of the add_filter('quirky_filter_tgmpa_required_plugins',	'quirky_wc_multivendor_marketplace_tgmpa_required_plugins');
    function quirky_wc_multivendor_marketplace_tgmpa_required_plugins( $list = array() ) {
        if ( quirky_storage_isset( 'required_plugins', 'wc-multivendor-marketplace' ) && quirky_storage_get_array( 'required_plugins', 'wc-multivendor-marketplace', 'install' ) !== false ) {
            $list[] = array(
                'name'     => quirky_storage_get_array( 'required_plugins', 'wc-multivendor-marketplace', 'title' ),
                'slug'     => 'wc-multivendor-marketplace',
                'required' => false,
            );
        }
        return $list;
    }
}
// Check if plugin installed and activated
if ( ! function_exists( 'quirky_exists_wc_multivendor_marketplace' ) ) {
    function quirky_exists_wc_multivendor_marketplace() {
        return  class_exists( 'WCFMmp' );
    }
}
// Return true, if current page is any wc-multivendor-marketplace page
if ( ! function_exists( 'quirky_is_wc_multivendor_marketplace_page' ) ) {
    function quirky_is_wc_multivendor_marketplace_page() {
        $rez = false;
        if ( quirky_exists_wc_frontend_manager() && quirky_exists_wc_multivendor_marketplace() ) {
            $rez = wcfmmp_is_store_page() || wcfmmp_is_stores_list_page() || wcfmmp_is_stores_map_page();
        }
        return $rez;
    }
}
// Detect current blog mode
if ( ! function_exists( 'quirky_wc_multivendor_marketplace_detect_blog_mode' ) ) {
    //Handler of the add_filter( 'quirky_filter_detect_blog_mode', 'quirky_wc_multivendor_marketplace_detect_blog_mode' );
    function quirky_wc_multivendor_marketplace_detect_blog_mode( $mode = '' ) {
        if ( wcfmmp_is_stores_list_page() || wcfmmp_is_stores_map_page() || wcfmmp_is_store_page() ) {
            $mode = 'store';
        }
        return $mode;
    }
}
// Detect if current post is a WCFM single post
if ( ! function_exists( 'quirky_wc_multivendor_marketplace_detect_single_post' ) ) {
    //Handler of the add_filter( 'quirky_filter_is_single', 'quirky_wc_multivendor_marketplace_detect_single_post' );
    function quirky_wc_multivendor_marketplace_detect_single_post( $mode ) {
		return $mode || wcfmmp_is_store_page();
	}
}

if ( ! function_exists( 'quirky_wc_multivendor_marketplace_loop_shop_columns_class' ) ) {
     //Handler of the add_filter( 'woocommerce_post_class', 'quirky_wc_multivendor_marketplace_loop_shop_columns_class' );
     //Handler of the add_filter( 'product_cat_class', 'quirky_wc_multivendor_marketplace_loop_shop_columns_class', 10, 3 );
    function quirky_wc_multivendor_marketplace_loop_shop_columns_class ( $classes, $class = '', $cat = '' ) {
        if ( wcfmmp_is_store_page() ) {
            $classes[] = ' column-1_' . esc_attr( max( 2, min( 4, quirky_get_theme_option( 'blog_columns_single_store' ) ) ) );
        }
        return $classes;
    }
}
    
