<?php
/* All Currencies for WooCommerce support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'quirky_woocommerce_all_currencies_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'quirky_woocommerce_all_currencies_theme_setup9', 9 );
	function quirky_woocommerce_all_currencies_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'quirky_filter_tgmpa_required_plugins', 'quirky_woocommerce_all_currencies_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'quirky_woocommerce_all_currencies_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('quirky_filter_tgmpa_required_plugins',	'quirky_woocommerce_all_currencies_tgmpa_required_plugins');
	function quirky_woocommerce_all_currencies_tgmpa_required_plugins( $list = array() ) {
		if ( quirky_storage_isset( 'required_plugins', 'woocommerce' ) && quirky_storage_isset( 'required_plugins', 'woocommerce-all-currencies' ) && quirky_storage_get_array( 'required_plugins', 'woocommerce-all-currencies', 'install' ) !== false ) {
			$list[] = array(
				'name'     => quirky_storage_get_array( 'required_plugins', 'woocommerce-all-currencies', 'title' ),
				'slug'     => 'woocommerce-all-currencies',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if this plugin installed and activated
if ( ! function_exists( 'quirky_exists_woocommerce_all_currencies' ) ) {
	function quirky_exists_woocommerce_all_currencies() {
		return class_exists( 'Alg_WC_All_Currencies' );
	}
}