<?php
/**
 * Required plugins
 *
 * @package QUIRKY
 * @since QUIRKY 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$quirky_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'quirky' ),
	'page_builders' => esc_html__( 'Page Builders', 'quirky' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'quirky' ),
	'socials'       => esc_html__( 'Socials and Communities', 'quirky' ),
	'events'        => esc_html__( 'Events and Appointments', 'quirky' ),
	'content'       => esc_html__( 'Content', 'quirky' ),
	'other'         => esc_html__( 'Other', 'quirky' ),
);
$quirky_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'quirky' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'quirky' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $quirky_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'quirky' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'quirky' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $quirky_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'quirky' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'quirky' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $quirky_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'quirky' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'quirky' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $quirky_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'quirky' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'quirky' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'woocommerce.png',
		'group'       => $quirky_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'quirky' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'quirky' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $quirky_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'quirky' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'quirky' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $quirky_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'quirky' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'quirky' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $quirky_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $quirky_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $quirky_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'quirky' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'quirky' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => quirky_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $quirky_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'quirky' ),
		'description' => '',
		'required'    => false,
		'logo'        => quirky_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => quirky_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => quirky_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $quirky_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => quirky_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $quirky_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => quirky_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'quirky' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'revslider.png',
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'quirky' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'quirky' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $quirky_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'quirky' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'quirky' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $quirky_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'quirky' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'quirky' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $quirky_theme_required_plugins_groups['other'],
	),
);

if ( QUIRKY_THEME_FREE ) {
	unset( $quirky_theme_required_plugins['js_composer'] );
	unset( $quirky_theme_required_plugins['booked'] );
	unset( $quirky_theme_required_plugins['the-events-calendar'] );
	unset( $quirky_theme_required_plugins['calculated-fields-form'] );
	unset( $quirky_theme_required_plugins['essential-grid'] );
	unset( $quirky_theme_required_plugins['revslider'] );
	unset( $quirky_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $quirky_theme_required_plugins['trx_updater'] );
	unset( $quirky_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
quirky_storage_set( 'required_plugins', $quirky_theme_required_plugins );
