<?php
/**
 * Skin Setup
 *
 * @package QUIRKY
 * @since QUIRKY 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'quirky_theme_defaults' ) ) {
	function quirky_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 130,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0,
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( empty( $value ) && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'quirky_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'quirky_skin_setup', 1 );
	function quirky_skin_setup() {

		$GLOBALS['QUIRKY_STORAGE'] = array_merge( $GLOBALS['QUIRKY_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-themerex',

			'theme_doc_url'       => '//quirky.themerex.net/doc',

			'theme_demofiles_url' => '//demofiles.themerex.net/quirky/',
			
			'theme_rate_url'      => '//themeforest.net/download',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/themerex/portfolio',            // ThemeREX

			'theme_video_url'     => '//www.youtube.com/channel/UCnFisBimrK2aIE-hnY70kCA',   // ThemeREX

			'theme_privacy_url'   => '//themerex.net/privacy-policy/',                       // ThemeREX

			'portfolio_url'       => '//themeforest.net/user/themerex/portfolio',            // ThemeREX


			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'quirky_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'quirky_skin_setup_settings', 1 );
	function quirky_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		quirky_storage_set_array( 'settings', 'thumbs_in_navigation', false );
        quirky_storage_set_array2( 'required_plugins', 'woocommerce', 'install', true);
        quirky_storage_set_array2( 'required_plugins', 'ti-woocommerce-wishlist', 'install', true);
        quirky_storage_set_array2( 'required_plugins', 'elegro-payment', 'install', true);
        // Add Skin Specific Plugins
		quirky_storage_set_array( 'required_plugins', 'wc-frontend-manager', array(
            'title'       => esc_html__( 'WCFM Frontend Manager', 'quirky' ),
            'description' => esc_html__( "Best multi vendor frontend store manager for WooCommerce", 'quirky' ),
            'required'    => false,
            'logo'        => quirky_get_file_url( 'plugins/wc-frontend-manager/wc-frontend-manager.png' ),
            'group'       => 'ecommerce',
        ) );
        $quirky_skin_path = quirky_get_file_dir( quirky_skins_get_current_skin_dir() . 'plugins/wc-frontend-manager/wc-frontend-manager.php' );
        if ( ! empty( $quirky_skin_path ) ) {
            require_once $quirky_skin_path;
        }
		quirky_storage_set_array( 'required_plugins', 'wc-multivendor-marketplace', array(
            'title'       => esc_html__( 'WCFM Marketplace', 'quirky' ),
            'description' => esc_html__( "Best Multivendor Marketplace for WooCommerce", 'quirky' ),
            'required'    => false,
            'logo'        => quirky_get_file_url( 'plugins/wc-multivendor-marketplace/wc-multivendor-marketplace.gif' ),
            'group'       => 'ecommerce',
        ) );
        $quirky_skin_path = quirky_get_file_dir( quirky_skins_get_current_skin_dir() . 'plugins/wc-multivendor-marketplace/wc-multivendor-marketplace.php' );
        if ( ! empty( $quirky_skin_path ) ) {
            require_once $quirky_skin_path;
        }
        quirky_storage_set_array( 'required_plugins', 'woocommerce-all-currencies', array(
            'title'       => esc_html__( 'All Currencies for WooCommerce', 'quirky' ),
            'description' => esc_html__( "The plugin extends WooCommerce e-commerce plugin by adding all world currencies and crypto currencies.", 'quirky' ),
            'required'    => false,
            'logo'        => quirky_get_file_url( 'plugins/woocommerce-all-currencies/woocommerce-all-currencies.png' ),
            'group'       => 'ecommerce',
        ) );
        $quirky_skin_path = quirky_get_file_dir( quirky_skins_get_current_skin_dir() . 'plugins/woocommerce-all-currencies/woocommerce-all-currencies.php' );
        if ( ! empty( $quirky_skin_path ) ) {
            require_once $quirky_skin_path;
        }
		quirky_storage_set_array( 'required_plugins', 'ultimate-woocommerce-auction', array(
            'title'       => esc_html__( 'Ultimate Auction for WooCommerce', 'quirky' ),
            'description' => esc_html__( "Ultimate Auction for WooCommerce allows easy and quick way to add your products as auctions on your site", 'quirky' ),
            'required'    => false,
            'logo'        => quirky_get_file_url( 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction.gif' ),
            'group'       => 'ecommerce',
        ) );
        $quirky_skin_path = quirky_get_file_dir( quirky_skins_get_current_skin_dir() . 'plugins/ultimate-woocommerce-auction/ultimate-woocommerce-auction.php' );
        if ( ! empty( $quirky_skin_path ) ) {
            require_once $quirky_skin_path;
        }
	}
}
// Add/remove/change Theme Options
if ( ! function_exists( 'quirky_skin_setup_options' ) ) {
    add_action( 'after_setup_theme', 'quirky_skin_setup_options', 3 );
    function quirky_skin_setup_options()  {
        quirky_storage_set_array2( 'options', 'footer_scheme', 'std', 'dark' );
    }
}


// Enqueue extra styles for frontend
if ( ! function_exists( 'quirky_trx_addons_extra_styles' ) ) {
    add_action( 'wp_enqueue_scripts', 'quirky_trx_addons_extra_styles', 2060 );
    function quirky_trx_addons_extra_styles() {
        $quirky_url = quirky_get_file_url( 'extra-styles.css' );
        if ( '' != $quirky_url ) {
            wp_enqueue_style( 'quirky-trx-addons-extra-styles', $quirky_url, array(), null );
        }
    }
}

// Custom styles
$quirky_skin_path = quirky_get_file_dir( quirky_skins_get_current_skin_dir() . 'extra-styles.php' );
if ( ! empty( $quirky_skin_path ) ) {
    require_once $quirky_skin_path;
}
// Customizer css
if ( ! function_exists( 'quirky_skin_customizer_control_js' ) ) {
	add_action( 'customize_controls_enqueue_scripts', 'quirky_skin_customizer_control_js' );
	function quirky_skin_customizer_control_js() {
		wp_enqueue_style( 'quirky-skin-customizer', quirky_get_file_url( 'skin-customizer.css' ), array(), null );
	}
}
// Load required styles and scripts for admin mode
if ( ! function_exists( 'quirky_skin_admin_scripts' ) ) {
	add_action('admin_enqueue_scripts', 'quirky_skin_admin_scripts');
	function quirky_skin_admin_scripts() {
		// Add theme admin styles
		wp_enqueue_style( 'quirky-skin-admin', quirky_get_file_url( 'skin-admin.css' ), array(), null );
	}
}
// Filter to add/remove shortcodes
if ( ! function_exists( 'quirky_skin_setup_trx_addons_sc_list' ) ) {
    add_filter('trx_addons_sc_list', 'quirky_skin_setup_trx_addons_sc_list');
    function quirky_skin_setup_trx_addons_sc_list($list = array()) {
        $list['blogger']['templates']['default']['over_centered_hover_price'] = array(
            'title' => esc_html__('Title with price over image', 'quirky'),
            'layout' => array(
                'featured' => array(
                    'mc' => array(
                        'title', 'price'
                    )
                ),
            )
        );
        return $list;
    }
}
// Add new output types (layouts) in the shortcodes
if ( ! function_exists( 'quirky_skin_setup_trx_addons_sc_type' ) ) {
    add_filter('trx_addons_sc_type', 'quirky_skin_setup_trx_addons_sc_type', 11, 2);
    function quirky_skin_setup_trx_addons_sc_type($list, $sc) {
        if ('trx_sc_layouts_menu' == $sc ) {
            $list['modern'] = 'Modern Burger';
        }
        return $list;
    }
}
// Modified export single user
if ( ! function_exists( 'quirky_skin_filter_export_single_user' ) ) {
    add_filter('trx_addons_filter_export_single_user', 'quirky_skin_filter_export_single_user', 11, 2);
	function quirky_skin_filter_export_single_user($mod, $orig) {
		$mod['display_name'] = $orig['display_name'];
		$mod['user_login'] = $orig['user_login'];
		$mod['user_nicename'] = $orig['user_nicename'];
		
		return $mod;
	}
}
// Modified export single usermeta
if ( ! function_exists( 'quirky_skin_filter_export_single_usermeta' ) ) {
    add_filter('trx_addons_filter_export_single_usermeta', 'quirky_skin_filter_export_single_usermeta', 11, 2);
	function quirky_skin_filter_export_single_usermeta($mod, $orig) {
		if   ( $mod['meta_key'] == 'nickname' ) $mod['meta_value'] = $orig['meta_value'];
		else if ( $mod['meta_key'] == 'first_name' ) $mod['meta_value'] = $orig['meta_value']; 
		else if ( $mod['meta_key'] == 'last_name' ) $mod['meta_value'] = $orig['meta_value']; 
		else if ( $mod['meta_key'] == 'billing_first_name' ) $mod['meta_value'] = $orig['meta_value']; 
		else if ( $mod['meta_key'] == 'billing_last_name' ) $mod['meta_value'] = $orig['meta_value']; 
		
		return $mod;
	}
}
// Modified export usermeta
if ( ! function_exists( 'quirky_skin_filter_export_usermeta' ) ) {
    add_filter('trx_addons_filter_export_usermeta', 'quirky_skin_filter_export_usermeta');
	function quirky_skin_filter_export_usermeta($rows) {
		if (is_array($rows) && count($rows)>0) {
			foreach ($rows as $k=>$v) {
				if  ($rows[$k]['meta_key'] == '_wcfm_vendor_tax_migrated')	unset($rows[$k]);
			}
		}
		return $rows;
	}
}

//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'quirky_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'quirky_skin_setup_fonts', 1 );
	function quirky_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		quirky_storage_set(
			'load_fonts', array(
				array(
					'name'   => 'roc-grotesk',
					'family' => 'sans-serif',
					'link'   => 'https://use.typekit.net/mwe5hxs.css',
					'styles' => ''
				),
				// Google font
				array(
					'name'   => 'Kumbh Sans',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'wght@100;200;300;400;500;600;700;800;900',     // Parameter 'style' used only for the Google fonts
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		quirky_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => basekit_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'quirky' );

		quirky_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'quirky' ) ),
					'font-family'     => '"Kumbh Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.72em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.77em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'quirky' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '3.563em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-1.8px',
					'margin-top'      => '1.1em',
					'margin-bottom'   => '0.4em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '2.938em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.5px',
					'margin-top'      => '0.8em',
					'margin-bottom'   => '0.4em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '2.188em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.1em',
					'margin-bottom'   => '0.6em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '1.625em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.25em',
					'margin-bottom'   => '0.7em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '1.500em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.417em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.22em',
					'margin-bottom'   => '0.7em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '1.188em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.474em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.6em',
					'margin-bottom'   => '0.9em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '1.7em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '16px',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '21px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'quirky' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '16px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.1px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'quirky' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '13px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'quirky' ) ),
					'font-family'     => 'roc-grotesk,sans-serif',
					'font-size'       => '17px',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'quirky' ) ),
					'font-family'     => '"Kumbh Sans",sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'quirky' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'quirky' ) ),
					'font-family'     => '"Kumbh Sans",sans-serif',
				),
			)
		);

		// Font presets
		quirky_storage_set(
			'font_presets', array(
				'karla' => array(
								'title'  => esc_html__( 'Karla', 'quirky' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Dancing Script',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
													// Google font
													array(
														'name'   => 'Sansita Swashed',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Dancing Script",fantasy',
														'font-size'       => '1.25rem',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
														'font-size'       => '4em',
													),
													'h2'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h3'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h4'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h5'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h6'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'logo'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'button'  => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'submenu' => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
												),
							),
				'roboto' => array(
								'title'  => esc_html__( 'Roboto', 'quirky' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Noto Sans JP',
														'family' => 'serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
													// Google font
													array(
														'name'   => 'Merriweather',
														'family' => 'sans-serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Noto Sans JP",serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
												),
							),
				'garamond' => array(
								'title'  => esc_html__( 'Garamond', 'quirky' ),
								'load_fonts' => array(
													// Adobe font
													array(
														'name'   => 'Europe',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
													// Adobe font
													array(
														'name'   => 'Sofia Pro',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Sofia Pro",sans-serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Europe,sans-serif',
													),
												),
							),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'quirky_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'quirky_skin_setup_schemes', 1 );
	function quirky_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		quirky_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'quirky' ),
					'description' => esc_html__( 'Colors of the main content area', 'quirky' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'quirky' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'quirky' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'quirky' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'quirky' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'quirky' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'quirky' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'quirky' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'quirky' ),
				),
			)
		);

		quirky_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'quirky' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'quirky' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'quirky' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'quirky' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'quirky' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'quirky' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'quirky' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'quirky' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'quirky' ),
					'description' => esc_html__( 'Color of the text inside this block', 'quirky' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'quirky' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'quirky' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'quirky' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'quirky' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'quirky' ),
					'description' => esc_html__( 'Color of the links inside this block', 'quirky' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'quirky' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'quirky' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'quirky' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'quirky' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'quirky' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'quirky' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'quirky' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'quirky' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'quirky' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'quirky' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'quirky' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F3F4ED', //ok
					'bd_color'         => '#D3D4CA', //ok

					// Text and links colors
					'text'             => '#707376', //ok
					'text_light'       => '#939289', //ok
					'text_dark'        => '#161921', //ok
					'text_link'        => '#9CBF10', //ok
					'text_hover'       => '#819D10', //ok
					'text_link2'       => '#2531EF', //ok
					'text_hover2'      => '#141FC7', //ok
					'text_link3'       => '#FFC107', //ok
					'text_hover3'      => '#E6AF09', //ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok
					'alter_bg_hover'   => '#ECEFE7', //ok
					'alter_bd_color'   => '#D3D4CA', //ok
					'alter_bd_hover'   => '#BCBEB1', //ok
					'alter_text'       => '#707376', //ok
					'alter_light'      => '#939289', //ok
					'alter_dark'       => '#161921', //ok
					'alter_link'       => '#9CBF10', //ok
					'alter_hover'      => '#819D10', //ok
					'alter_link2'      => '#2531EF', //ok
					'alter_hover2'     => '#141FC7', //ok
					'alter_link3'      => '#FFC107', //ok
					'alter_hover3'     => '#E6AF09', //ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040610', //ok
					'extra_bg_hover'   => '#1B2033',
					'extra_bd_color'   => '#242A40',
					'extra_bd_hover'   => '#464C65',
					'extra_text'       => '#9B9FAF', //ok
					'extra_light'      => '#7A7F91',
					'extra_dark'       => '#FCFCFC', //ok
					'extra_link'       => '#9CBF10', //ok
					'extra_hover'      => '#FCFCFC', //ok
					'extra_link2'      => '#2531EF',
					'extra_hover2'     => '#141FC7',
					'extra_link3'      => '#FFC107',
					'extra_hover3'     => '#E6AF09',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok
					'input_bg_hover'   => 'transparent', //ok
					'input_bd_color'   => '#D3D4CA', //ok
					'input_bd_hover'   => '#BCBEB1', //ok
					'input_text'       => '#707376', //ok
					'input_light'      => '#939289', //ok
					'input_dark'       => '#161921', //ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#161921',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#161921', //ok
					'inverse_link'     => '#FFFFFF', //ok
					'inverse_hover'    => '#FFFFFF', //ok

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'quirky' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#04071B', //ok
					'bd_color'         => '#242A40', //ok

					// Text and links colors
					'text'             => '#9B9FAF', //ok
					'text_light'       => '#7A7F91', //ok
					'text_dark'        => '#FCFCFC', //ok
					'text_link'        => '#9CBF10', //ok
					'text_hover'       => '#819D10', //ok
					'text_link2'       => '#2531EF', //ok
					'text_hover2'      => '#141FC7', //ok
					'text_link3'       => '#FFC107', //ok
					'text_hover3'      => '#E6AF09', //ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#111421', //ok
					'alter_bg_hover'   => '#1B2033', //ok
					'alter_bd_color'   => '#242A40', //ok
					'alter_bd_hover'   => '#464C65', //ok
					'alter_text'       => '#9B9FAF', //ok
					'alter_light'      => '#7A7F91', //ok
					'alter_dark'       => '#FCFCFC', //ok
					'alter_link'       => '#9CBF10', //ok
					'alter_hover'      => '#819D10', //ok
					'alter_link2'      => '#2531EF', //ok
					'alter_hover2'     => '#141FC7', //ok
					'alter_link3'      => '#FFC107', //ok
					'alter_hover3'     => '#E6AF09', //ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040610', //ok
					'extra_bg_hover'   => '#1B2033',
					'extra_bd_color'   => '#242A40',
					'extra_bd_hover'   => '#464C65',
					'extra_text'       => '#9B9FAF', //ok
					'extra_light'      => '#7A7F91',
					'extra_dark'       => '#FCFCFC', //ok
					'extra_link'       => '#9CBF10', //ok
					'extra_hover'      => '#FCFCFC', //ok
					'extra_link2'      => '#2531EF',
					'extra_hover2'     => '#141FC7',
					'extra_link3'      => '#FFC107',
					'extra_hover3'     => '#E6AF09',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok
					'input_bg_hover'   => '#transparent', //ok
					'input_bd_color'   => '#242A40', //ok
					'input_bd_hover'   => '#464C65', //ok
					'input_text'       => '#9B9FAF', //ok
					'input_light'      => '#7A7F91', //ok
					'input_dark'       => '#FCFCFC', //ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FCFCFC', //ok
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#161921', //ok
					'inverse_link'     => '#FFFFFF', //ok
					'inverse_hover'    => '#161921', //ok

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

            // Color scheme: 'light'
            'light' => array(
                'title'    => esc_html__( 'Light', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF', //ok
                    'bd_color'         => '#D3D4CA', //ok

                    // Text and links colors
                    'text'             => '#707376', //ok
                    'text_light'       => '#939289', //ok
                    'text_dark'        => '#161921', //ok
                    'text_link'        => '#9CBF10', //ok
                    'text_hover'       => '#819D10', //ok
                    'text_link2'       => '#2531EF', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F3F4ED', //ok
                    'alter_bg_hover'   => '#ECEFE7', //ok
                    'alter_bd_color'   => '#D3D4CA', //ok
                    'alter_bd_hover'   => '#BCBEB1', //ok
                    'alter_text'       => '#707376', //ok
                    'alter_light'      => '#939289', //ok
                    'alter_dark'       => '#161921', //ok
                    'alter_link'       => '#9CBF10', //ok
                    'alter_hover'      => '#819D10', //ok
                    'alter_link2'      => '#2531EF', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#9CBF10', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#2531EF',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#D3D4CA', //ok
                    'input_bd_hover'   => '#BCBEB1', //ok
                    'input_text'       => '#707376', //ok
                    'input_light'      => '#939289', //ok
                    'input_dark'       => '#161921', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#161921',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'orange_default'
            'orange_default' => array(
                'title'    => esc_html__( 'Orange Default', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#F2F2EB', //ok
                    'bd_color'         => '#CFD0C6', //ok

                    // Text and links colors
                    'text'             => '#65645F', //ok
                    'text_light'       => '#807F7C', //ok
                    'text_dark'        => '#161921', //ok
                    'text_link'        => '#EB5021', //ok orange
                    'text_hover'       => '#CE3D11', //ok orange
                    'text_link2'       => '#2531EF', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#FFFFFF', //ok
                    'alter_bg_hover'   => '#EAE9E2', //ok
                    'alter_bd_color'   => '#CFD0C6', //ok
                    'alter_bd_hover'   => '#BFBFBD', //ok
                    'alter_text'       => '#65645F', //ok
                    'alter_light'      => '#807F7C', //ok
                    'alter_dark'       => '#161921', //ok
                    'alter_link'       => '#EB5021', //ok orange
                    'alter_hover'      => '#CE3D11', //ok orange
                    'alter_link2'      => '#2531EF', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#EB5021', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#2531EF',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#CFD0C6', //ok
                    'input_bd_hover'   => '#BFBFBD', //ok
                    'input_text'       => '#65645F', //ok
                    'input_light'      => '#807F7C', //ok
                    'input_dark'       => '#161921', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#161921',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'orange_dark'
            'orange_dark'    => array(
                'title'    => esc_html__( 'Orange Dark', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#04071B', //ok
                    'bd_color'         => '#242A40', //ok

                    // Text and links colors
                    'text'             => '#9B9FAF', //ok
                    'text_light'       => '#7A7F91', //ok
                    'text_dark'        => '#FCFCFC', //ok
                    'text_link'        => '#EB5021', //ok orange
                    'text_hover'       => '#CE3D11', //ok orange
                    'text_link2'       => '#2531EF', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#111421', //ok
                    'alter_bg_hover'   => '#1B2033', //ok
                    'alter_bd_color'   => '#242A40', //ok
                    'alter_bd_hover'   => '#464C65', //ok
                    'alter_text'       => '#9B9FAF', //ok
                    'alter_light'      => '#7A7F91', //ok
                    'alter_dark'       => '#FCFCFC', //ok
                    'alter_link'       => '#EB5021', //ok orange
                    'alter_hover'      => '#CE3D11', //ok orange
                    'alter_link2'      => '#2531EF', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#EB5021', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#2531EF',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => '#transparent', //ok
                    'input_bg_hover'   => '#transparent', //ok
                    'input_bd_color'   => '#242A40', //ok
                    'input_bd_hover'   => '#464C65', //ok
                    'input_text'       => '#9B9FAF', //ok
                    'input_light'      => '#7A7F91', //ok
                    'input_dark'       => '#FCFCFC', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#e36650',
                    'inverse_bd_hover' => '#cb5b47',
                    'inverse_text'     => '#FCFCFC', //ok
                    'inverse_light'    => '#6f6f6f',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#161921', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'orange_light'
            'orange_light' => array(
                'title'    => esc_html__( 'Orange Light', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF', //ok
                    'bd_color'         => '#CFD0C6', //ok

                    // Text and links colors
                    'text'             => '#65645F', //ok
                    'text_light'       => '#807F7C', //ok
                    'text_dark'        => '#161921', //ok
                    'text_link'        => '#EB5021', //ok orange
                    'text_hover'       => '#CE3D11', //ok orange
                    'text_link2'       => '#2531EF', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F2F2EB', //ok
                    'alter_bg_hover'   => '#EAE9E2', //ok
                    'alter_bd_color'   => '#CFD0C6', //ok
                    'alter_bd_hover'   => '#BFBFBD', //ok
                    'alter_text'       => '#65645F', //ok
                    'alter_light'      => '#807F7C', //ok
                    'alter_dark'       => '#161921', //ok
                    'alter_link'       => '#EB5021', //ok orange
                    'alter_hover'      => '#CE3D11', //ok orange
                    'alter_link2'      => '#2531EF', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#EB5021', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#2531EF',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#CFD0C6', //ok
                    'input_bd_hover'   => '#BFBFBD', //ok
                    'input_text'       => '#65645F', //ok
                    'input_light'      => '#807F7C', //ok
                    'input_dark'       => '#161921', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#161921',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'ruby_default'
            'ruby_default' => array(
                'title'    => esc_html__( 'Ruby Default', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#F0F6F7', //ok
                    'bd_color'         => '#EAEAEA', //ok

                    // Text and links colors
                    'text'             => '#707376', //ok
                    'text_light'       => '#7C7E80', //ok
                    'text_dark'        => '#161921', //ok
                    'text_link'        => '#FC0100', //ok ruby
                    'text_hover'       => '#D90100', //ok ruby
                    'text_link2'       => '#1B00EB', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#FFFFFF', //ok
                    'alter_bg_hover'   => '#D0DCDE', //ok
                    'alter_bd_color'   => '#EAEAEA', //ok
                    'alter_bd_hover'   => '#DADFE0', //ok
                    'alter_text'       => '#707376', //ok
                    'alter_light'      => '#7C7E80', //ok
                    'alter_dark'       => '#161921', //ok
                    'alter_link'       => '#FC0100', //ok ruby
                    'alter_hover'      => '#D90100', //ok ruby
                    'alter_link2'      => '#1B00EB', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#FC0100', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#1B00EB',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#EAEAEA', //ok
                    'input_bd_hover'   => '#DADFE0', //ok
                    'input_text'       => '#707376', //ok
                    'input_light'      => '#7C7E80', //ok
                    'input_dark'       => '#161921', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#161921',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'ruby_dark'
            'ruby_dark'    => array(
                'title'    => esc_html__( 'Ruby Dark', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#04071B', //ok
                    'bd_color'         => '#242A40', //ok

                    // Text and links colors
                    'text'             => '#9B9FAF', //ok
                    'text_light'       => '#7A7F91', //ok
                    'text_dark'        => '#FCFCFC', //ok
                    'text_link'        => '#FC0100', //ok ruby
                    'text_hover'       => '#D90100', //ok ruby
                    'text_link2'       => '#1B00EB', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#111421', //ok
                    'alter_bg_hover'   => '#1B2033', //ok
                    'alter_bd_color'   => '#242A40', //ok
                    'alter_bd_hover'   => '#464C65', //ok
                    'alter_text'       => '#9B9FAF', //ok
                    'alter_light'      => '#7A7F91', //ok
                    'alter_dark'       => '#FCFCFC', //ok
                    'alter_link'       => '#FC0100', //ok ruby
                    'alter_hover'      => '#D90100', //ok ruby
                    'alter_link2'      => '#1B00EB', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#FC0100', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#1B00EB',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => '#transparent', //ok
                    'input_bg_hover'   => '#transparent', //ok
                    'input_bd_color'   => '#242A40', //ok
                    'input_bd_hover'   => '#464C65', //ok
                    'input_text'       => '#9B9FAF', //ok
                    'input_light'      => '#7A7F91', //ok
                    'input_dark'       => '#FCFCFC', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#e36650',
                    'inverse_bd_hover' => '#cb5b47',
                    'inverse_text'     => '#FCFCFC', //ok
                    'inverse_light'    => '#6f6f6f',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#161921', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'ruby_light'
            'ruby_light' => array(
                'title'    => esc_html__( 'Ruby Light', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF', //ok
                    'bd_color'         => '#EAEAEA', //ok

                    // Text and links colors
                    'text'             => '#707376', //ok
                    'text_light'       => '#7C7E80', //ok
                    'text_dark'        => '#161921', //ok
                    'text_link'        => '#FC0100', //ok ruby
                    'text_hover'       => '#D90100', //ok ruby
                    'text_link2'       => '#1B00EB', //ok
                    'text_hover2'      => '#141FC7', //ok
                    'text_link3'       => '#FFC107', //ok
                    'text_hover3'      => '#E6AF09', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F0F6F7', //ok
                    'alter_bg_hover'   => '#D0DCDE', //ok
                    'alter_bd_color'   => '#EAEAEA', //ok
                    'alter_bd_hover'   => '#DADFE0', //ok
                    'alter_text'       => '#707376', //ok
                    'alter_light'      => '#7C7E80', //ok
                    'alter_dark'       => '#161921', //ok
                    'alter_link'       => '#FC0100', //ok ruby
                    'alter_hover'      => '#D90100', //ok ruby
                    'alter_link2'      => '#1B00EB', //ok
                    'alter_hover2'     => '#141FC7', //ok
                    'alter_link3'      => '#FFC107', //ok
                    'alter_hover3'     => '#E6AF09', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#040610', //ok
                    'extra_bg_hover'   => '#1B2033',
                    'extra_bd_color'   => '#242A40',
                    'extra_bd_hover'   => '#464C65',
                    'extra_text'       => '#9B9FAF', //ok
                    'extra_light'      => '#7A7F91',
                    'extra_dark'       => '#FCFCFC', //ok
                    'extra_link'       => '#FC0100', //ok
                    'extra_hover'      => '#FCFCFC', //ok
                    'extra_link2'      => '#1B00EB',
                    'extra_hover2'     => '#141FC7',
                    'extra_link3'      => '#FFC107',
                    'extra_hover3'     => '#E6AF09',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#EAEAEA', //ok
                    'input_bd_hover'   => '#DADFE0', //ok
                    'input_text'       => '#707376', //ok
                    'input_light'      => '#7C7E80', //ok
                    'input_dark'       => '#161921', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#161921',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#161921', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'lilac_default'
            'lilac_default' => array(
                'title'    => esc_html__( 'Lilac Default', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#F7F7F8', //ok
                    'bd_color'         => '#E0E0E4', //ok

                    // Text and links colors
                    'text'             => '#626275', //ok
                    'text_light'       => '#818291', //ok
                    'text_dark'        => '#060725', //ok
                    'text_link'        => '#BA45E3', //ok lilac
                    'text_hover'       => '#AD2FD9', //ok lilac
                    'text_link2'       => '#EC1879', //ok
                    'text_hover2'      => '#D8176F', //ok
                    'text_link3'       => '#C0D003', //ok
                    'text_hover3'      => '#AEBC01', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#FFFFFF', //ok
                    'alter_bg_hover'   => '#EEEEF1', //ok
                    'alter_bd_color'   => '#E0E0E4', //ok
                    'alter_bd_hover'   => '#C8C8CF', //ok
                    'alter_text'       => '#626275', //ok
                    'alter_light'      => '#818291', //ok
                    'alter_dark'       => '#060725', //ok
                    'alter_link'       => '#BA45E3', //ok
                    'alter_hover'      => '#AD2FD9', //ok
                    'alter_link2'      => '#EC1879', //ok
                    'alter_hover2'     => '#D8176F', //ok
                    'alter_link3'      => '#C0D003', //ok
                    'alter_hover3'     => '#AEBC01', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#010221', //ok
                    'extra_bg_hover'   => '#161732',
                    'extra_bd_color'   => '#262740',
                    'extra_bd_hover'   => '#4E4F64',
                    'extra_text'       => '#8E8EAC', //ok
                    'extra_light'      => '#60607E',
                    'extra_dark'       => '#F7F7F8', //ok
                    'extra_link'       => '#BA45E3', //ok lilac
                    'extra_hover'      => '#F7F7F8', //ok
                    'extra_link2'      => '#EC1879',
                    'extra_hover2'     => '#D8176F',
                    'extra_link3'      => '#C0D003',
                    'extra_hover3'     => '#AEBC01',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#E0E0E4', //ok
                    'input_bd_hover'   => '#C8C8CF', //ok
                    'input_text'       => '#626275', //ok
                    'input_light'      => '#818291', //ok
                    'input_dark'       => '#060725', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#060725',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#060725', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'lilac_dark'
            'lilac_dark'    => array(
                'title'    => esc_html__( 'Lilac Dark', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#010221', //ok
                    'bd_color'         => '#262740', //ok

                    // Text and links colors
                    'text'             => '#8E8EAC', //ok
                    'text_light'       => '#60607E', //ok
                    'text_dark'        => '#F7F7F8', //ok
                    'text_link'        => '#BA45E3', //ok lilac
                    'text_hover'       => '#AD2FD9', //ok lilac
                    'text_link2'       => '#EC1879', //ok
                    'text_hover2'      => '#D8176F', //ok
                    'text_link3'       => '#C0D003', //ok
                    'text_hover3'      => '#AEBC01', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#0F0F2B', //ok
                    'alter_bg_hover'   => '#161732', //ok
                    'alter_bd_color'   => '#262740', //ok
                    'alter_bd_hover'   => '#4E4F64', //ok
                    'alter_text'       => '#8E8EAC', //ok
                    'alter_light'      => '#60607E', //ok
                    'alter_dark'       => '#F7F7F8', //ok
                    'alter_link'       => '#BA45E3', //ok lilac
                    'alter_hover'      => '#AD2FD9', //ok lilac
                    'alter_link2'      => '#EC1879', //ok
                    'alter_hover2'     => '#D8176F', //ok
                    'alter_link3'      => '#C0D003', //ok
                    'alter_hover3'     => '#AEBC01', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#010221', //ok
                    'extra_bg_hover'   => '#161732',
                    'extra_bd_color'   => '#262740',
                    'extra_bd_hover'   => '#4E4F64',
                    'extra_text'       => '#8E8EAC', //ok
                    'extra_light'      => '#60607E',
                    'extra_dark'       => '#F7F7F8', //ok
                    'extra_link'       => '#BA45E3', //ok lilac
                    'extra_hover'      => '#F7F7F8', //ok
                    'extra_link2'      => '#EC1879',
                    'extra_hover2'     => '#D8176F',
                    'extra_link3'      => '#C0D003',
                    'extra_hover3'     => '#AEBC01',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => '#transparent', //ok
                    'input_bg_hover'   => '#transparent', //ok
                    'input_bd_color'   => '#262740', //ok
                    'input_bd_hover'   => '#4E4F64', //ok
                    'input_text'       => '#8E8EAC', //ok
                    'input_light'      => '#60607E', //ok
                    'input_dark'       => '#F7F7F8', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#e36650',
                    'inverse_bd_hover' => '#cb5b47',
                    'inverse_text'     => '#F7F7F8', //ok
                    'inverse_light'    => '#6f6f6f',
                    'inverse_dark'     => '#060725', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#060725', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),

            // Color scheme: 'lilac_light'
            'lilac_light' => array(
                'title'    => esc_html__( 'Lilac Light', 'quirky' ),
                'internal' => true,
                'colors'   => array(

                    // Whole block border and background
                    'bg_color'         => '#FFFFFF', //ok
                    'bd_color'         => '#E0E0E4', //ok

                    // Text and links colors
                    'text'             => '#626275', //ok
                    'text_light'       => '#818291', //ok
                    'text_dark'        => '#060725', //ok
                    'text_link'        => '#BA45E3', //ok lilac
                    'text_hover'       => '#AD2FD9', //ok lilac
                    'text_link2'       => '#EC1879', //ok
                    'text_hover2'      => '#D8176F', //ok
                    'text_link3'       => '#C0D003', //ok
                    'text_hover3'      => '#AEBC01', //ok

                    // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                    'alter_bg_color'   => '#F7F7F8', //ok
                    'alter_bg_hover'   => '#EEEEF1', //ok
                    'alter_bd_color'   => '#E0E0E4', //ok
                    'alter_bd_hover'   => '#C8C8CF', //ok
                    'alter_text'       => '#626275', //ok
                    'alter_light'      => '#818291', //ok
                    'alter_dark'       => '#060725', //ok
                    'alter_link'       => '#BA45E3', //ok
                    'alter_hover'      => '#AD2FD9', //ok
                    'alter_link2'      => '#EC1879', //ok
                    'alter_hover2'     => '#D8176F', //ok
                    'alter_link3'      => '#C0D003', //ok
                    'alter_hover3'     => '#AEBC01', //ok

                    // Extra blocks (submenu, tabs, color blocks, etc.)
                    'extra_bg_color'   => '#010221', //ok
                    'extra_bg_hover'   => '#161732',
                    'extra_bd_color'   => '#262740',
                    'extra_bd_hover'   => '#4E4F64',
                    'extra_text'       => '#8E8EAC', //ok
                    'extra_light'      => '#60607E',
                    'extra_dark'       => '#F7F7F8', //ok
                    'extra_link'       => '#BA45E3', //ok lilac
                    'extra_hover'      => '#F7F7F8', //ok
                    'extra_link2'      => '#EC1879',
                    'extra_hover2'     => '#D8176F',
                    'extra_link3'      => '#C0D003',
                    'extra_hover3'     => '#AEBC01',

                    // Input fields (form's fields and textarea)
                    'input_bg_color'   => 'transparent', //ok
                    'input_bg_hover'   => 'transparent', //ok
                    'input_bd_color'   => '#E0E0E4', //ok
                    'input_bd_hover'   => '#C8C8CF', //ok
                    'input_text'       => '#626275', //ok
                    'input_light'      => '#818291', //ok
                    'input_dark'       => '#060725', //ok

                    // Inverse blocks (text and links on the 'text_link' background)
                    'inverse_bd_color' => '#67bcc1',
                    'inverse_bd_hover' => '#5aa4a9',
                    'inverse_text'     => '#060725',
                    'inverse_light'    => '#333333',
                    'inverse_dark'     => '#060725', //ok
                    'inverse_link'     => '#FFFFFF', //ok
                    'inverse_hover'    => '#FFFFFF', //ok

                    // Additional (skin-specific) colors.
                    // Attention! Set of colors must be equal in all color schemes.
                    //---> For example:
                    //---> 'new_color1'         => '#rrggbb',
                    //---> 'alter_new_color1'   => '#rrggbb',
                    //---> 'inverse_new_color1' => '#rrggbb',
                ),
            ),
		);
		quirky_storage_set( 'schemes', $schemes );
		quirky_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> quirky_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'quirky' ),
		//---> 	'description' => __( 'Description of the new color 1', 'quirky' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		quirky_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_05'      => array(
					'color' => 'text_link',
					'alpha' => 0.5,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		quirky_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		quirky_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		quirky_storage_set(
			'color_presets', array(
				'autumn' => array(
								'title'  => esc_html__( 'Autumn', 'quirky' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	),
												'dark' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	)
												)
							),
				'green' => array(
								'title'  => esc_html__( 'Natural Green', 'quirky' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	),
												'dark' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	)
												)
							),
			)
		);
	}
}

// Activation methods
if ( ! function_exists( 'quirky_skin_filter_activation_methods2' ) ) {
    add_filter( 'trx_addons_filter_activation_methods', 'quirky_skin_filter_activation_methods2', 11, 1 );
    function quirky_skin_filter_activation_methods2( $args ) {
        $args['elements_key'] = true;
        return $args;
    }
}
