<?php
/**
 * The template to display Admin notices
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.1
 */

$quirky_theme_slug = get_option( 'template' );
$quirky_theme_obj  = wp_get_theme( $quirky_theme_slug );
?>
<div class="quirky_admin_notice quirky_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$quirky_theme_img = quirky_get_file_url( 'screenshot.jpg' );
	if ( '' != $quirky_theme_img ) {
		?>
		<div class="quirky_notice_image"><img src="<?php echo esc_url( $quirky_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'quirky' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="quirky_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'quirky' ),
				$quirky_theme_obj->get( 'Name' ) . ( QUIRKY_THEME_FREE ? ' ' . __( 'Free', 'quirky' ) : '' ),
				$quirky_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="quirky_notice_text">
		<p class="quirky_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $quirky_theme_obj->description ) );
			?>
		</p>
		<p class="quirky_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'quirky' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="quirky_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=quirky_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'quirky' );
			?>
		</a>
	</div>
</div>
