<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package QUIRKY
 * @since QUIRKY 1.71.0
 */

$quirky_template_args = get_query_var( 'quirky_template_args' );

$quirky_columns       = 1;

$quirky_expanded      = ! quirky_sidebar_present() && quirky_get_theme_option( 'expand_content' ) == 'expand';

$quirky_post_format   = get_post_format();
$quirky_post_format   = empty( $quirky_post_format ) ? 'standard' : str_replace( 'post-format-', '', $quirky_post_format );

if ( is_array( $quirky_template_args ) ) {
	$quirky_columns    = empty( $quirky_template_args['columns'] ) ? 1 : max( 1, $quirky_template_args['columns'] );
	$quirky_blog_style = array( $quirky_template_args['type'], $quirky_columns );
	if ( ! empty( $quirky_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $quirky_columns > 1 ) {
	    $quirky_columns_class = quirky_get_column_class( 1, $quirky_columns, ! empty( $quirky_template_args['columns_tablet']) ? $quirky_template_args['columns_tablet'] : '', ! empty($quirky_template_args['columns_mobile']) ? $quirky_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $quirky_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $quirky_post_format ) );
	quirky_add_blog_animation( $quirky_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$quirky_hover      = ! empty( $quirky_template_args['hover'] ) && ! quirky_is_inherit( $quirky_template_args['hover'] )
							? $quirky_template_args['hover']
							: quirky_get_theme_option( 'image_hover' );
	$quirky_components = ! empty( $quirky_template_args['meta_parts'] )
							? ( is_array( $quirky_template_args['meta_parts'] )
								? $quirky_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $quirky_template_args['meta_parts'] ) )
								)
							: quirky_array_get_keys_by_value( quirky_get_theme_option( 'meta_parts' ) );
	quirky_show_post_featured( apply_filters( 'quirky_filter_args_featured',
		array(
			'no_links'   => ! empty( $quirky_template_args['no_links'] ),
			'hover'      => $quirky_hover,
			'meta_parts' => $quirky_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $quirky_template_args['thumb_size'] )
								? $quirky_template_args['thumb_size']
								: quirky_get_thumb_size( 
								in_array( $quirky_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( quirky_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $quirky_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$quirky_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$quirky_show_title = get_the_title() != '';
		$quirky_show_meta  = count( $quirky_components ) > 0 && ! in_array( $quirky_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $quirky_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'quirky_filter_show_blog_categories', $quirky_show_meta && in_array( 'categories', $quirky_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'quirky_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						quirky_show_post_meta( apply_filters(
															'quirky_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $quirky_hover, 1
															)
											);
						?>
					</div>
					<?php
					$quirky_components = quirky_array_delete_by_value( $quirky_components, 'categories' );
					do_action( 'quirky_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'quirky_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'quirky_action_before_post_title' );
					if ( empty( $quirky_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'quirky_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $quirky_template_args['excerpt_length'] ) && ! in_array( $quirky_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$quirky_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'quirky_filter_show_blog_excerpt', empty( $quirky_template_args['hide_excerpt'] ) && quirky_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				quirky_show_post_content( $quirky_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'quirky_filter_show_blog_meta', $quirky_show_meta, $quirky_components, 'band' ) ) {
			if ( count( $quirky_components ) > 0 ) {
				do_action( 'quirky_action_before_post_meta' );
				quirky_show_post_meta(
					apply_filters(
						'quirky_filter_post_meta_args', array(
							'components' => join( ',', $quirky_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'quirky_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'quirky_filter_show_blog_readmore', ! $quirky_show_title || ! empty( $quirky_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $quirky_template_args['no_links'] ) ) {
				do_action( 'quirky_action_before_post_readmore' );
				quirky_show_post_more_link( $quirky_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'quirky_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $quirky_template_args ) ) {
	if ( ! empty( $quirky_template_args['slider'] ) || $quirky_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
