<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

$quirky_template_args = get_query_var( 'quirky_template_args' );

if ( is_array( $quirky_template_args ) ) {
	$quirky_columns    = empty( $quirky_template_args['columns'] ) ? 2 : max( 1, $quirky_template_args['columns'] );
	$quirky_blog_style = array( $quirky_template_args['type'], $quirky_columns );
    $quirky_columns_class = quirky_get_column_class( 1, $quirky_columns, ! empty( $quirky_template_args['columns_tablet']) ? $quirky_template_args['columns_tablet'] : '', ! empty($quirky_template_args['columns_mobile']) ? $quirky_template_args['columns_mobile'] : '' );
} else {
	$quirky_blog_style = explode( '_', quirky_get_theme_option( 'blog_style' ) );
	$quirky_columns    = empty( $quirky_blog_style[1] ) ? 2 : max( 1, $quirky_blog_style[1] );
    $quirky_columns_class = quirky_get_column_class( 1, $quirky_columns );
}
$quirky_expanded   = ! quirky_sidebar_present() && quirky_get_theme_option( 'expand_content' ) == 'expand';

$quirky_post_format = get_post_format();
$quirky_post_format = empty( $quirky_post_format ) ? 'standard' : str_replace( 'post-format-', '', $quirky_post_format );

?><div class="<?php
	if ( ! empty( $quirky_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( quirky_is_blog_style_use_masonry( $quirky_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $quirky_columns ) : esc_attr( $quirky_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $quirky_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $quirky_columns )
				. ' post_layout_' . esc_attr( $quirky_blog_style[0] )
				. ' post_layout_' . esc_attr( $quirky_blog_style[0] ) . '_' . esc_attr( $quirky_columns )
	);
	quirky_add_blog_animation( $quirky_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$quirky_hover      = ! empty( $quirky_template_args['hover'] ) && ! quirky_is_inherit( $quirky_template_args['hover'] )
							? $quirky_template_args['hover']
							: quirky_get_theme_option( 'image_hover' );

	$quirky_components = ! empty( $quirky_template_args['meta_parts'] )
							? ( is_array( $quirky_template_args['meta_parts'] )
								? $quirky_template_args['meta_parts']
								: explode( ',', $quirky_template_args['meta_parts'] )
								)
							: quirky_array_get_keys_by_value( quirky_get_theme_option( 'meta_parts' ) );

	quirky_show_post_featured( apply_filters( 'quirky_filter_args_featured',
		array(
			'thumb_size' => ! empty( $quirky_template_args['thumb_size'] )
				? $quirky_template_args['thumb_size']
				: quirky_get_thumb_size(
					'classic' == $quirky_blog_style[0]
						? ( strpos( quirky_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $quirky_columns > 2 ? 'big' : 'huge' )
								: ( $quirky_columns > 2
									? ( $quirky_expanded ? 'square' : 'square' )
									: ($quirky_columns > 1 ? 'square' : ( $quirky_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( quirky_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $quirky_columns > 2 ? 'masonry-big' : 'full' )
								: ($quirky_columns === 1 ? ( $quirky_expanded ? 'huge' : 'big' ) : ( $quirky_columns <= 2 && $quirky_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $quirky_hover,
			'meta_parts' => $quirky_components,
			'no_links'   => ! empty( $quirky_template_args['no_links'] ),
        ),
        'content-classic',
        $quirky_template_args
    ) );

	// Title and post meta
	$quirky_show_title = get_the_title() != '';
	$quirky_show_meta  = count( $quirky_components ) > 0 && ! in_array( $quirky_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $quirky_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'quirky_filter_show_blog_meta', $quirky_show_meta, $quirky_components, 'classic' ) ) {
				if ( count( $quirky_components ) > 0 ) {
					do_action( 'quirky_action_before_post_meta' );
					quirky_show_post_meta(
						apply_filters(
							'quirky_filter_post_meta_args', array(
							'components' => join( ',', $quirky_components ),
							'seo'        => false,
							'echo'       => true,
						), $quirky_blog_style[0], $quirky_columns
						)
					);
					do_action( 'quirky_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'quirky_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'quirky_action_before_post_title' );
				if ( empty( $quirky_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'quirky_action_after_post_title' );
			}

			if( !in_array( $quirky_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'quirky_filter_show_blog_readmore', ! $quirky_show_title || ! empty( $quirky_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $quirky_template_args['no_links'] ) ) {
						do_action( 'quirky_action_before_post_readmore' );
						quirky_show_post_more_link( $quirky_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'quirky_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $quirky_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('quirky_filter_show_blog_excerpt', empty($quirky_template_args['hide_excerpt']) && quirky_get_theme_option('excerpt_length') > 0, 'classic')) {
			quirky_show_post_content($quirky_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $quirky_template_args['more_button'] )) {
			if ( empty( $quirky_template_args['no_links'] ) ) {
				do_action( 'quirky_action_before_post_readmore' );
				quirky_show_post_more_link( $quirky_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'quirky_action_after_post_readmore' );
			}
		}
		$quirky_content = ob_get_contents();
		ob_end_clean();
		quirky_show_layout($quirky_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
