<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.50
 */

$quirky_template_args = get_query_var( 'quirky_template_args' );
if ( is_array( $quirky_template_args ) ) {
	$quirky_columns    = empty( $quirky_template_args['columns'] ) ? 2 : max( 1, $quirky_template_args['columns'] );
	$quirky_blog_style = array( $quirky_template_args['type'], $quirky_columns );
} else {
	$quirky_blog_style = explode( '_', quirky_get_theme_option( 'blog_style' ) );
	$quirky_columns    = empty( $quirky_blog_style[1] ) ? 2 : max( 1, $quirky_blog_style[1] );
}
$quirky_blog_id       = quirky_get_custom_blog_id( join( '_', $quirky_blog_style ) );
$quirky_blog_style[0] = str_replace( 'blog-custom-', '', $quirky_blog_style[0] );
$quirky_expanded      = ! quirky_sidebar_present() && quirky_get_theme_option( 'expand_content' ) == 'expand';
$quirky_components    = ! empty( $quirky_template_args['meta_parts'] )
							? ( is_array( $quirky_template_args['meta_parts'] )
								? join( ',', $quirky_template_args['meta_parts'] )
								: $quirky_template_args['meta_parts']
								)
							: quirky_array_get_keys_by_value( quirky_get_theme_option( 'meta_parts' ) );
$quirky_post_format   = get_post_format();
$quirky_post_format   = empty( $quirky_post_format ) ? 'standard' : str_replace( 'post-format-', '', $quirky_post_format );

$quirky_blog_meta     = quirky_get_custom_layout_meta( $quirky_blog_id );
$quirky_custom_style  = ! empty( $quirky_blog_meta['scripts_required'] ) ? $quirky_blog_meta['scripts_required'] : 'none';

if ( ! empty( $quirky_template_args['slider'] ) || $quirky_columns > 1 || ! quirky_is_off( $quirky_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $quirky_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( quirky_is_off( $quirky_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $quirky_custom_style ) ) . "-1_{$quirky_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $quirky_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $quirky_columns )
					. ' post_layout_' . esc_attr( $quirky_blog_style[0] )
					. ' post_layout_' . esc_attr( $quirky_blog_style[0] ) . '_' . esc_attr( $quirky_columns )
					. ( ! quirky_is_off( $quirky_custom_style )
						? ' post_layout_' . esc_attr( $quirky_custom_style )
							. ' post_layout_' . esc_attr( $quirky_custom_style ) . '_' . esc_attr( $quirky_columns )
						: ''
						)
		);
	quirky_add_blog_animation( $quirky_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'quirky_action_show_layout', $quirky_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $quirky_template_args['slider'] ) || $quirky_columns > 1 || ! quirky_is_off( $quirky_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
