<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

$quirky_template_args = get_query_var( 'quirky_template_args' );
$quirky_columns = 1;
if ( is_array( $quirky_template_args ) ) {
	$quirky_columns    = empty( $quirky_template_args['columns'] ) ? 1 : max( 1, $quirky_template_args['columns'] );
	$quirky_blog_style = array( $quirky_template_args['type'], $quirky_columns );
	if ( ! empty( $quirky_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $quirky_columns > 1 ) {
	    $quirky_columns_class = quirky_get_column_class( 1, $quirky_columns, ! empty( $quirky_template_args['columns_tablet']) ? $quirky_template_args['columns_tablet'] : '', ! empty($quirky_template_args['columns_mobile']) ? $quirky_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $quirky_columns_class ); ?>">
		<?php
	}
}
$quirky_expanded    = ! quirky_sidebar_present() && quirky_get_theme_option( 'expand_content' ) == 'expand';
$quirky_post_format = get_post_format();
$quirky_post_format = empty( $quirky_post_format ) ? 'standard' : str_replace( 'post-format-', '', $quirky_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $quirky_post_format ) );
	quirky_add_blog_animation( $quirky_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$quirky_hover      = ! empty( $quirky_template_args['hover'] ) && ! quirky_is_inherit( $quirky_template_args['hover'] )
							? $quirky_template_args['hover']
							: quirky_get_theme_option( 'image_hover' );
	$quirky_components = ! empty( $quirky_template_args['meta_parts'] )
							? ( is_array( $quirky_template_args['meta_parts'] )
								? $quirky_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $quirky_template_args['meta_parts'] ) )
								)
							: quirky_array_get_keys_by_value( quirky_get_theme_option( 'meta_parts' ) );
	quirky_show_post_featured( apply_filters( 'quirky_filter_args_featured',
		array(
			'no_links'   => ! empty( $quirky_template_args['no_links'] ),
			'hover'      => $quirky_hover,
			'meta_parts' => $quirky_components,
			'thumb_size' => ! empty( $quirky_template_args['thumb_size'] )
							? $quirky_template_args['thumb_size']
							: quirky_get_thumb_size( strpos( quirky_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $quirky_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$quirky_template_args
	) );

	// Title and post meta
	$quirky_show_title = get_the_title() != '';
	$quirky_show_meta  = count( $quirky_components ) > 0 && ! in_array( $quirky_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $quirky_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'quirky_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'quirky_action_before_post_title' );
				if ( empty( $quirky_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'quirky_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'quirky_filter_show_blog_excerpt', empty( $quirky_template_args['hide_excerpt'] ) && quirky_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'quirky_filter_show_blog_meta', $quirky_show_meta, $quirky_components, 'excerpt' ) ) {
				if ( count( $quirky_components ) > 0 ) {
					do_action( 'quirky_action_before_post_meta' );
					quirky_show_post_meta(
						apply_filters(
							'quirky_filter_post_meta_args', array(
								'components' => join( ',', $quirky_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'quirky_action_after_post_meta' );
				}
			}

			if ( quirky_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'quirky_action_before_full_post_content' );
					the_content( '' );
					do_action( 'quirky_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'quirky' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'quirky' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				quirky_show_post_content( $quirky_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'quirky_filter_show_blog_readmore',  ! isset( $quirky_template_args['more_button'] ) || ! empty( $quirky_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $quirky_template_args['no_links'] ) ) {
					do_action( 'quirky_action_before_post_readmore' );
					if ( quirky_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						quirky_show_post_more_link( $quirky_template_args, '<p>', '</p>' );
					} else {
						quirky_show_post_comments_link( $quirky_template_args, '<p>', '</p>' );
					}
					do_action( 'quirky_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $quirky_template_args ) ) {
	if ( ! empty( $quirky_template_args['slider'] ) || $quirky_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
