<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

$quirky_template_args = get_query_var( 'quirky_template_args' );
if ( is_array( $quirky_template_args ) ) {
	$quirky_columns    = empty( $quirky_template_args['columns'] ) ? 2 : max( 1, $quirky_template_args['columns'] );
	$quirky_blog_style = array( $quirky_template_args['type'], $quirky_columns );
    $quirky_columns_class = quirky_get_column_class( 1, $quirky_columns, ! empty( $quirky_template_args['columns_tablet']) ? $quirky_template_args['columns_tablet'] : '', ! empty($quirky_template_args['columns_mobile']) ? $quirky_template_args['columns_mobile'] : '' );
} else {
	$quirky_blog_style = explode( '_', quirky_get_theme_option( 'blog_style' ) );
	$quirky_columns    = empty( $quirky_blog_style[1] ) ? 2 : max( 1, $quirky_blog_style[1] );
    $quirky_columns_class = quirky_get_column_class( 1, $quirky_columns );
}

$quirky_post_format = get_post_format();
$quirky_post_format = empty( $quirky_post_format ) ? 'standard' : str_replace( 'post-format-', '', $quirky_post_format );

?><div class="
<?php
if ( ! empty( $quirky_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( quirky_is_blog_style_use_masonry( $quirky_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $quirky_columns ) : esc_attr( $quirky_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $quirky_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $quirky_columns )
		. ( 'portfolio' != $quirky_blog_style[0] ? ' ' . esc_attr( $quirky_blog_style[0] )  . '_' . esc_attr( $quirky_columns ) : '' )
	);
	quirky_add_blog_animation( $quirky_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$quirky_hover   = ! empty( $quirky_template_args['hover'] ) && ! quirky_is_inherit( $quirky_template_args['hover'] )
								? $quirky_template_args['hover']
								: quirky_get_theme_option( 'image_hover' );

	if ( 'dots' == $quirky_hover ) {
		$quirky_post_link = empty( $quirky_template_args['no_links'] )
								? ( ! empty( $quirky_template_args['link'] )
									? $quirky_template_args['link']
									: get_permalink()
									)
								: '';
		$quirky_target    = ! empty( $quirky_post_link ) && false === strpos( $quirky_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$quirky_components = ! empty( $quirky_template_args['meta_parts'] )
							? ( is_array( $quirky_template_args['meta_parts'] )
								? $quirky_template_args['meta_parts']
								: explode( ',', $quirky_template_args['meta_parts'] )
								)
							: quirky_array_get_keys_by_value( quirky_get_theme_option( 'meta_parts' ) );

	// Featured image
	quirky_show_post_featured( apply_filters( 'quirky_filter_args_featured',
        array(
			'hover'         => $quirky_hover,
			'no_links'      => ! empty( $quirky_template_args['no_links'] ),
			'thumb_size'    => ! empty( $quirky_template_args['thumb_size'] )
								? $quirky_template_args['thumb_size']
								: quirky_get_thumb_size(
									quirky_is_blog_style_use_masonry( $quirky_blog_style[0] )
										? (	strpos( quirky_get_theme_option( 'body_style' ), 'full' ) !== false || $quirky_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( quirky_get_theme_option( 'body_style' ), 'full' ) !== false || $quirky_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => quirky_is_blog_style_use_masonry( $quirky_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $quirky_components,
			'class'         => 'dots' == $quirky_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $quirky_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $quirky_post_link )
												? '<a href="' . esc_url( $quirky_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $quirky_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $quirky_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $quirky_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!