<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$quirky_copyright_scheme = quirky_get_theme_option( 'copyright_scheme' );
if ( ! empty( $quirky_copyright_scheme ) && ! quirky_is_inherit( $quirky_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $quirky_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$quirky_copyright = quirky_get_theme_option( 'copyright' );
			if ( ! empty( $quirky_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$quirky_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $quirky_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$quirky_copyright = quirky_prepare_macros( $quirky_copyright );
				// Display copyright
				echo wp_kses( nl2br( $quirky_copyright ), 'quirky_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
