<?php
/**
 * The template to display default site footer
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.10
 */

$quirky_footer_id = quirky_get_custom_footer_id();
$quirky_footer_meta = get_post_meta( $quirky_footer_id, 'trx_addons_options', true );
if ( ! empty( $quirky_footer_meta['margin'] ) ) {
	quirky_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( quirky_prepare_css_value( $quirky_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $quirky_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $quirky_footer_id ) ) ); ?>
						<?php
						$quirky_footer_scheme = quirky_get_theme_option( 'footer_scheme' );
						if ( ! empty( $quirky_footer_scheme ) && ! quirky_is_inherit( $quirky_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $quirky_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'quirky_action_show_layout', $quirky_footer_id );
	?>
</footer><!-- /.footer_wrap -->
