<?php
/**
 * The template to display the site logo in the footer
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.10
 */

// Logo
if ( quirky_is_on( quirky_get_theme_option( 'logo_in_footer' ) ) ) {
	$quirky_logo_image = quirky_get_logo_image( 'footer' );
	$quirky_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $quirky_logo_image['logo'] ) || ! empty( $quirky_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $quirky_logo_image['logo'] ) ) {
					$quirky_attr = quirky_getimagesize( $quirky_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $quirky_logo_image['logo'] ) . '"'
								. ( ! empty( $quirky_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $quirky_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'quirky' ) . '"'
								. ( ! empty( $quirky_attr[3] ) ? ' ' . wp_kses_data( $quirky_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $quirky_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $quirky_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
