<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.10
 */

// Footer sidebar
$quirky_footer_name    = quirky_get_theme_option( 'footer_widgets' );
$quirky_footer_present = ! quirky_is_off( $quirky_footer_name ) && is_active_sidebar( $quirky_footer_name );
if ( $quirky_footer_present ) {
	quirky_storage_set( 'current_sidebar', 'footer' );
	$quirky_footer_wide = quirky_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $quirky_footer_name ) ) {
		dynamic_sidebar( $quirky_footer_name );
	}
	$quirky_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $quirky_out ) ) {
		$quirky_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $quirky_out );
		$quirky_need_columns = true;   //or check: strpos($quirky_out, 'columns_wrap')===false;
		if ( $quirky_need_columns ) {
			$quirky_columns = max( 0, (int) quirky_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $quirky_columns ) {
				$quirky_columns = min( 4, max( 1, quirky_tags_count( $quirky_out, 'aside' ) ) );
			}
			if ( $quirky_columns > 1 ) {
				$quirky_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $quirky_columns ) . ' widget', $quirky_out );
			} else {
				$quirky_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $quirky_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'quirky_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $quirky_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $quirky_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'quirky_action_before_sidebar', 'footer' );
				quirky_show_layout( $quirky_out );
				do_action( 'quirky_action_after_sidebar', 'footer' );
				if ( $quirky_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $quirky_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'quirky_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
