<?php
/**
 * The template to display default site header
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

$quirky_header_css   = '';
$quirky_header_image = get_header_image();
$quirky_header_video = quirky_get_header_video();
if ( ! empty( $quirky_header_image ) && quirky_trx_addons_featured_image_override( is_singular() || quirky_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$quirky_header_image = quirky_get_current_mode_image( $quirky_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $quirky_header_image ) || ! empty( $quirky_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $quirky_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $quirky_header_image ) {
		echo ' ' . esc_attr( quirky_add_inline_css_class( 'background-image: url(' . esc_url( $quirky_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( quirky_is_on( quirky_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight quirky-full-height';
	}
	$quirky_header_scheme = quirky_get_theme_option( 'header_scheme' );
	if ( ! empty( $quirky_header_scheme ) && ! quirky_is_inherit( $quirky_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $quirky_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $quirky_header_video ) ) {
		get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( quirky_is_on( quirky_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'quirky_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
