<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

// Page (category, tag, archive, author) title

if ( quirky_need_page_title() ) {
	quirky_sc_layouts_showed( 'title', true );
	quirky_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								quirky_show_post_meta(
									apply_filters(
										'quirky_filter_post_meta_args', array(
											'components' => join( ',', quirky_array_get_keys_by_value( quirky_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', quirky_array_get_keys_by_value( quirky_get_theme_option( 'counters' ) ) ),
											'seo'        => quirky_is_on( quirky_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$quirky_blog_title           = quirky_get_blog_title();
							$quirky_blog_title_text      = '';
							$quirky_blog_title_class     = '';
							$quirky_blog_title_link      = '';
							$quirky_blog_title_link_text = '';
							if ( is_array( $quirky_blog_title ) ) {
								$quirky_blog_title_text      = $quirky_blog_title['text'];
								$quirky_blog_title_class     = ! empty( $quirky_blog_title['class'] ) ? ' ' . $quirky_blog_title['class'] : '';
								$quirky_blog_title_link      = ! empty( $quirky_blog_title['link'] ) ? $quirky_blog_title['link'] : '';
								$quirky_blog_title_link_text = ! empty( $quirky_blog_title['link_text'] ) ? $quirky_blog_title['link_text'] : '';
							} else {
								$quirky_blog_title_text = $quirky_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $quirky_blog_title_class ); ?>">
								<?php
								$quirky_top_icon = quirky_get_term_image_small();
								if ( ! empty( $quirky_top_icon ) ) {
									$quirky_attr = quirky_getimagesize( $quirky_top_icon );
									?>
									<img src="<?php echo esc_url( $quirky_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'quirky' ); ?>"
										<?php
										if ( ! empty( $quirky_attr[3] ) ) {
											quirky_show_layout( $quirky_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $quirky_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $quirky_blog_title_link ) && ! empty( $quirky_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $quirky_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $quirky_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'quirky_action_breadcrumbs' );
						$quirky_breadcrumbs = ob_get_contents();
						ob_end_clean();
						quirky_show_layout( $quirky_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
