<?php
/**
 * The template to display the widgets area in the header
 *
 * @package QUIRKY
 * @since QUIRKY 1.0
 */

// Header sidebar
$quirky_header_name    = quirky_get_theme_option( 'header_widgets' );
$quirky_header_present = ! quirky_is_off( $quirky_header_name ) && is_active_sidebar( $quirky_header_name );
if ( $quirky_header_present ) {
	quirky_storage_set( 'current_sidebar', 'header' );
	$quirky_header_wide = quirky_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $quirky_header_name ) ) {
		dynamic_sidebar( $quirky_header_name );
	}
	$quirky_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $quirky_widgets_output ) ) {
		$quirky_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $quirky_widgets_output );
		$quirky_need_columns   = strpos( $quirky_widgets_output, 'columns_wrap' ) === false;
		if ( $quirky_need_columns ) {
			$quirky_columns = max( 0, (int) quirky_get_theme_option( 'header_columns' ) );
			if ( 0 == $quirky_columns ) {
				$quirky_columns = min( 6, max( 1, quirky_tags_count( $quirky_widgets_output, 'aside' ) ) );
			}
			if ( $quirky_columns > 1 ) {
				$quirky_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $quirky_columns ) . ' widget', $quirky_widgets_output );
			} else {
				$quirky_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $quirky_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'quirky_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $quirky_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $quirky_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'quirky_action_before_sidebar', 'header' );
				quirky_show_layout( $quirky_widgets_output );
				do_action( 'quirky_action_after_sidebar', 'header' );
				if ( $quirky_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $quirky_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'quirky_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
