<?php
/**
 * The template to display Admin notices
 *
 * @package QUIRKY
 * @since QUIRKY 1.0.64
 */

$quirky_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$quirky_skins_args = get_query_var( 'quirky_skins_notice_args' );
?>
<div class="quirky_admin_notice quirky_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$quirky_theme_img = quirky_get_file_url( 'screenshot.jpg' );
	if ( '' != $quirky_theme_img ) {
		?>
		<div class="quirky_notice_image"><img src="<?php echo esc_url( $quirky_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'quirky' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="quirky_notice_title">
		<?php esc_html_e( 'New skins available', 'quirky' ); ?>
	</h3>
	<?php

	// Description
	$quirky_total      = $quirky_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$quirky_skins_msg  = $quirky_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $quirky_total, 'quirky' ), $quirky_total ) . '</strong>'
							: '';
	$quirky_total      = $quirky_skins_args['free'];
	$quirky_skins_msg .= $quirky_total > 0
							? ( ! empty( $quirky_skins_msg ) ? ' ' . esc_html__( 'and', 'quirky' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $quirky_total, 'quirky' ), $quirky_total ) . '</strong>'
							: '';
	$quirky_total      = $quirky_skins_args['pay'];
	$quirky_skins_msg .= $quirky_skins_args['pay'] > 0
							? ( ! empty( $quirky_skins_msg ) ? ' ' . esc_html__( 'and', 'quirky' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $quirky_total, 'quirky' ), $quirky_total ) . '</strong>'
							: '';
	?>
	<div class="quirky_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'quirky' ), $quirky_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="quirky_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $quirky_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'quirky' );
			?>
		</a>
	</div>
</div>
