<?php
/**
 * Register custom customizer panels, sections and settings.
 *
 * @package    Beginner
 * @author     Theme Junkie
 * @copyright  Copyright (c) 2016, Theme Junkie
 * @license    http://www.gnu.org/licenses/gpl-2.0.html
 * @since      1.0.0
 */

/**
 * We register our custom customizer by using the hook.
 *
 * @since  1.0.0
 */
function beginner_customizer_register() {

	// Stores all the controls that will be added
	$options = array();

	// Stores all the sections to be added
	$sections = array();

	// Stores all the panels to be added
	$panels = array();

	// Adds the sections to the $options array
	$options['sections'] = $sections;

	// ======= Start Customizer Panels/Sections/Settings ======= //

	// General Panels and Sections
	$general_panel = 'general';

	$panels[] = array(
		'id'          => $general_panel,
		'title'       => esc_html__( 'General', 'beginner' ),
		'description' => esc_html__( 'This panel is used for managing general section of your site.', 'beginner' ),
		'priority'    => 10
	);

		// RSS
		$section = PREFIX . 'rss-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'RSS', 'beginner' ),
			'priority'    => 100,
			'panel'       => $general_panel,
			'description' => esc_html__( 'If you fill the custom rss url below, it will replace the default.', 'beginner' ),
		);
		$options[PREFIX . 'custom-rss'] = array(
			'id'           => PREFIX . 'custom-rss',
			'label'        => esc_html__( 'Custom RSS URL (eg. Feedburner)', 'beginner' ),
			'section'      => $section,
			'type'         => 'url',
			'default'      => ''
		);

		// Comment
		$section = PREFIX . 'comment-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Comments', 'beginner' ),
			'priority'    => 110,
			'panel'       => $general_panel,
		);
		$options[PREFIX . 'page-comment'] = array(
			'id'           => PREFIX . 'page-comment',
			'label'        => esc_html__( 'Page Comment', 'beginner' ),
			'section'      => $section,
			'type'         => 'switch',
			'default'      => 1
		);

		// Post Date Style
		$section = PREFIX . 'date-style-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Post Date', 'beginner' ),
			'priority'    => 115,
			'panel'       => $general_panel
		);
		$options[PREFIX . 'post-date-style'] = array(
			'id'          => PREFIX . 'post-date-style',
			'label'       => esc_html__( 'Style', 'beginner' ),
			'section'     => $section,
			'type'        => 'select',
			'default'     => 'absolute',
			'choices'     => array(
				'absolute' => esc_html__( 'Absolute (June 20, 2015 10:19 am)', 'beginner' ),
				'relative' => esc_html__( 'Relative (1 week ago)', 'beginner' )
			)
		);
		$options[PREFIX . 'post-date-type'] = array(
			'id'          => PREFIX . 'post-date-type',
			'label'       => esc_html__( 'Type', 'beginner' ),
			'section'     => $section,
			'type'        => 'select',
			'default'     => 'published',
			'choices'     => array(
				'published' => esc_html__( 'Published Date', 'beginner' ),
				'modified'  => esc_html__( 'Modified Date', 'beginner' )
			)
		);

		// Social header
		$section = PREFIX . 'social-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Social', 'beginner' ),
			'priority'    => 130,
			'panel'       => $general_panel
		);
		$options[PREFIX . 'twitter'] = array(
			'id'      => PREFIX . 'twitter',
			'label'   => esc_html__( 'Twitter URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'facebook'] = array(
			'id'      => PREFIX . 'facebook',
			'label'   => esc_html__( 'Facebook URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'gplus'] = array(
			'id'      => PREFIX . 'gplus',
			'label'   => esc_html__( 'Google Plus URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'instagram'] = array(
			'id'      => PREFIX . 'instagram',
			'label'   => esc_html__( 'Instagram URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'pinterest'] = array(
			'id'      => PREFIX . 'pinterest',
			'label'   => esc_html__( 'Pinterest URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'linkedin'] = array(
			'id'      => PREFIX . 'linkedin',
			'label'   => esc_html__( 'LinkedIn URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'tumblr'] = array(
			'id'      => PREFIX . 'tumblr',
			'label'   => esc_html__( 'Tumblr URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);
		$options[PREFIX . 'rss'] = array(
			'id'      => PREFIX . 'rss',
			'label'   => esc_html__( 'RSS URL', 'beginner' ),
			'section' => $section,
			'type'    => 'url',
			'default' => ''
		);

		// Newsletter scriont
		$section = PREFIX . 'newsletter-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Newsletter', 'beginner' ),
			'priority'    => 135,
			'panel'       => $general_panel,
		);
		$options[PREFIX . 'newsletter-heading'] = array(
			'id'      => PREFIX . 'newsletter-heading',
			'label'   => esc_html__( 'Heading', 'beginner' ),
			'section' => $section,
			'type'    => 'text',
			'default' => esc_html__( 'Download your Free E-Book', 'beginner' )
		);
		$options[PREFIX . 'newsletter-title'] = array(
			'id'      => PREFIX . 'newsletter-title',
			'label'   => esc_html__( 'Title', 'beginner' ),
			'section' => $section,
			'type'    => 'text',
			'default' => esc_html__( 'Sign Up Today for Free!', 'beginner' )
		);
		$options[PREFIX . 'newsletter-desc'] = array(
			'id'      => PREFIX . 'newsletter-desc',
			'label'   => esc_html__( 'Description', 'beginner' ),
			'section' => $section,
			'type'    => 'text',
			'default' => esc_html__( 'Subscribe to our mailing list and get useful stuff and updates to your email inbox', 'beginner' )
		);
		$options[PREFIX . 'newsletter-type'] = array(
			'id'      => PREFIX . 'newsletter-type',
			'label'   => esc_html__( 'Newsletter Type', 'beginner' ),
			'section' => $section,
			'type'    => 'radio',
			'choices' => array(
				'feedburner' => esc_html__( 'FeedBurner', 'beginner' ),
				'custom'     => esc_html__( 'Custom Code', 'beginner' )
			),
			'default' => 'feedburner'
		);
		$options[PREFIX . 'newsletter-feedburner'] = array(
			'id'              => PREFIX . 'newsletter-feedburner',
			'label'           => esc_html__( 'FeedBurner ID', 'beginner' ),
			'section'         => $section,
			'type'            => 'text',
			'default'         => esc_html__( 'ThemeJunkie', 'beginner' ),
			'active_callback' => 'beginner_newsletter_feedburner_callback'
		);
		$options[PREFIX . 'newsletter-form'] = array(
			'id'                => PREFIX . 'newsletter-form',
			'label'             => esc_html__( 'Newsletter Form', 'beginner' ),
			'section'           => $section,
			'type'              => 'textarea',
			'sanitize_callback' => 'beginner_textarea_stripslashes',
			'default'           => '',
			'active_callback'   => 'beginner_newsletter_custom_callback'
		);
		$options[PREFIX . 'newsletter-visibility'] = array(
			'id'          => PREFIX . 'newsletter-visibility',
			'label'       => esc_html__( 'Visibility', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'newsletter-front'] = array(
				'id'          => PREFIX . 'newsletter-front',
				'label'       => esc_html__( 'Show on Front page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'newsletter-home'] = array(
				'id'          => PREFIX . 'newsletter-home',
				'label'       => esc_html__( 'Show on Home page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'newsletter-archive'] = array(
				'id'          => PREFIX . 'newsletter-archive',
				'label'       => esc_html__( 'Show on Archive page', 'beginner' ),
				'description' => esc_html__( 'Blog, date, month and year page.', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-author'] = array(
				'id'          => PREFIX . 'newsletter-author',
				'label'       => esc_html__( 'Show on Author page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-category'] = array(
				'id'          => PREFIX . 'newsletter-category',
				'label'       => esc_html__( 'Show on Category page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-tag'] = array(
				'id'          => PREFIX . 'newsletter-tag',
				'label'       => esc_html__( 'Show on Tag page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-search'] = array(
				'id'          => PREFIX . 'newsletter-search',
				'label'       => esc_html__( 'Show on Search page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-404'] = array(
				'id'          => PREFIX . 'newsletter-404',
				'label'       => esc_html__( 'Show on 404 page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-post'] = array(
				'id'          => PREFIX . 'newsletter-post',
				'label'       => esc_html__( 'Show on Single Post', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'newsletter-page'] = array(
				'id'          => PREFIX . 'newsletter-page',
				'label'       => esc_html__( 'Show on Single Page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);

		// Footer Text
		$section = PREFIX . 'footer-text-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Footer Text', 'beginner' ),
			'priority'    => 140,
			'panel'       => $general_panel,
		);
		$theme = wp_get_theme();
		$options[PREFIX . 'footer-text'] = array(
			'id'           => PREFIX . 'footer-text',
			'label'        => '',
			'description'  => esc_html__( 'Customize the footer text.', 'beginner' ),
			'section'      => $section,
			'type'         => 'textarea',
			'default'      => sprintf( esc_html__( '&copy; %1$s %2$s &middot; %3$s %4$s by %5$s', 'beginner' ),
				date( 'Y' ),
				'<a href="' . esc_url( home_url() ) . '">' . esc_attr( get_bloginfo( 'name' ) ) . '</a>',
				'<span class="themejunkie">',
				'<a href="' . esc_url( $theme->get( 'ThemeURI' ) ) . '">' . esc_attr( $theme->get( 'Name' ) ) . '</a>',
				'<a href="' . esc_url( $theme->get( 'AuthorURI' ) ) . '">' . esc_attr( $theme->get( 'Author' ) ) . '</a></span>' )
		);

	// Header Panels and Sections
	$header_panel = 'header';

	$panels[] = array(
		'id'          => $header_panel,
		'title'       => esc_html__( 'Header', 'beginner' ),
		'description' => esc_html__( 'This panel is used for managing header section of your site.', 'beginner' ),
		'priority'    => 15
	);

		// Logo
		$section = PREFIX . 'logo-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Logo', 'beginner' ),
			'priority'    => 30,
			'panel'       => $header_panel
		);
		$options[PREFIX . 'logo'] = array(
			'id'      => PREFIX . 'logo',
			'label'   => esc_html__( 'Regular Logo', 'beginner' ),
			'section' => $section,
			'type'    => 'media',
			'default' => ''
		);

		// Search icon and form
		$section = PREFIX . 'search-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Search', 'beginner' ),
			'description' => esc_html__( 'Show search icon and form', 'beginner' ),
			'priority'    => 40,
			'panel'       => $header_panel
		);
		$options[PREFIX . 'search-header'] = array(
			'id'      => PREFIX . 'search-header',
			'label'   => '',
			'section' => $section,
			'type'    => 'switch',
			'default' => 1
		);

	// Colors Panel and Sections
	$color_panel = 'color';

	$panels[] = array(
		'id'          => $color_panel,
		'title'       => esc_html__( 'Color', 'beginner' ),
		'description' => esc_html__( 'This panel is used for managing colors of your site.', 'beginner' ),
		'priority'    => 20
	);

		// Predefined color
		$section = PREFIX . 'predefined-color-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Predefined Skins', 'beginner' ),
			'priority'    => 5,
			'panel'       => $color_panel
		);
		$options[PREFIX . 'skins'] = array(
			'id'          => PREFIX . 'skins',
			'label'       => esc_html__( 'Skins', 'beginner' ),
			'section'     => $section,
			'type'        => 'radio',
			'default'     => 'default',
			'choices'     => array(
				'default' => esc_html__( 'Default', 'beginner' ),
				'green'   => esc_html__( 'Green', 'beginner' ),
				'cyan'    => esc_html__( 'Cyan', 'beginner' ),
				'magenta' => esc_html__( 'Magenta', 'beginner' ),
				'blue'    => esc_html__( 'Blue', 'beginner' ),
			)
		);

	// Typography Panel and Sections
	$typo_panel = 'typography';

	$panels[] = array(
		'id'          => $typo_panel,
		'title'       => esc_html__( 'Typography', 'beginner' ),
		'description' => esc_html__( 'This panel is used for managing typography of your site.', 'beginner' ),
		'priority'    => 30
	);

		// Global typography
		$section = PREFIX . 'global-typography';
		$font_choices = customizer_library_get_font_choices();

		$sections[] = array(
			'id'       => $section,
			'title'    => esc_html__( 'Global', 'beginner' ),
			'priority' => 5,
			'panel'    => $typo_panel
		);
		$options[PREFIX . 'primary-font'] = array(
			'id'          => PREFIX . 'primary-font',
			'label'       => esc_html__( 'Primary font', 'beginner' ),
			'section'     => $section,
			'type'        => 'select2',
			'choices'     => $font_choices,
			'default'     => 'Merriweather',
		);
		$options[PREFIX . 'secondary-font'] = array(
			'id'          => PREFIX . 'secondary-font',
			'label'       => esc_html__( 'Secondary font', 'beginner' ),
			'section'     => $section,
			'type'        => 'select2',
			'choices'     => $font_choices,
			'default'     => 'Droid Sans',
		);

	// Content Panel and Sections
	$content_panel = 'layouts';

	$panels[] = array(
		'id'          => $content_panel,
		'title'       => esc_html__( 'Layouts', 'beginner' ),
		'description' => esc_html__( 'This panel is used for managing several custom features/layouts of your site.', 'beginner' ),
		'priority'    => 35
	);

		// Featured posts
		$section = PREFIX . 'featured-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Featured Posts', 'beginner' ),
			'priority'    => 5,
			'panel'       => $content_panel
		);
		$options[PREFIX . 'featured-select'] = array(
			'id'          => PREFIX . 'featured-select',
			'label'       => esc_html__( 'Select a tag', 'beginner' ),
			'section'     => $section,
			'type'        => 'select2',
			'choices'     => beginner_tags_list()
		);
		$options[PREFIX . 'featured-num'] = array(
			'id'          => PREFIX . 'featured-num',
			'label'       => esc_html__( 'Number of posts', 'beginner' ),
			'section'     => $section,
			'type'        => 'text',
			'default'     => 4
		);
		$options[PREFIX . 'featured-orderby'] = array(
			'id'          => PREFIX . 'featured-orderby',
			'label'       => esc_html__( 'Order by', 'beginner' ),
			'section'     => $section,
			'type'        => 'select',
			'default'     => 'date',
			'choices'     => array(
				'date'  => esc_html__( 'Date', 'beginner' ),
				'rand'  => esc_html__( 'Random', 'beginner' )
			)
		);
		$options[PREFIX . 'featured-title'] = array(
			'id'          => PREFIX . 'featured-title',
			'label'       => esc_html__( 'Featured Title', 'beginner' ),
			'section'     => $section,
			'type'        => 'text',
			'default'     => esc_html__( 'Hot <span>News</span>', 'beginner' )
		);
		$options[PREFIX . 'featured-more'] = array(
			'id'          => PREFIX . 'featured-more',
			'label'       => esc_html__( 'More Text', 'beginner' ),
			'section'     => $section,
			'type'        => 'text',
			'default'     => esc_html__( 'More News', 'beginner' )
		);
		$options[PREFIX . 'featured-visibility'] = array(
			'id'          => PREFIX . 'featured-visibility',
			'label'       => esc_html__( 'Visibility', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'featured-front'] = array(
				'id'          => PREFIX . 'featured-front',
				'label'       => esc_html__( 'Show on Front page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'featured-home'] = array(
				'id'          => PREFIX . 'featured-home',
				'label'       => esc_html__( 'Show on Home page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'featured-archive'] = array(
				'id'          => PREFIX . 'featured-archive',
				'label'       => esc_html__( 'Show on Archive page', 'beginner' ),
				'description' => esc_html__( 'Blog, date, month and year page.', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-author'] = array(
				'id'          => PREFIX . 'featured-author',
				'label'       => esc_html__( 'Show on Author page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-category'] = array(
				'id'          => PREFIX . 'featured-category',
				'label'       => esc_html__( 'Show on Category page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-tag'] = array(
				'id'          => PREFIX . 'featured-tag',
				'label'       => esc_html__( 'Show on Tag page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-search'] = array(
				'id'          => PREFIX . 'featured-search',
				'label'       => esc_html__( 'Show on Search page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-404'] = array(
				'id'          => PREFIX . 'featured-404',
				'label'       => esc_html__( 'Show on 404 page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-post'] = array(
				'id'          => PREFIX . 'featured-post',
				'label'       => esc_html__( 'Show on Single Post', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);
			$options[PREFIX . 'featured-page'] = array(
				'id'          => PREFIX . 'featured-page',
				'label'       => esc_html__( 'Show on Single Page', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 0
			);

		// Posts
		$section = PREFIX . 'posts-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Posts', 'beginner' ),
			'description' => esc_html__( 'Posts is a single post page.', 'beginner' ),
			'priority'    => 10,
			'panel'       => $content_panel
		);
		$options[PREFIX . 'post-header-group'] = array(
			'id'          => PREFIX . 'post-header-group',
			'label'       => esc_html__( 'Post Header', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'post-breadcrumb'] = array(
				'id'          => PREFIX . 'post-breadcrumb',
				'label'       => esc_html__( 'Show post breadcrumb', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-author'] = array(
				'id'          => PREFIX . 'post-author',
				'label'       => esc_html__( 'Show post author name', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-cat'] = array(
				'id'          => PREFIX . 'post-cat',
				'label'       => esc_html__( 'Show post categories', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-date'] = array(
				'id'          => PREFIX . 'post-date',
				'label'       => esc_html__( 'Show post date', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-thumbnail'] = array(
				'id'          => PREFIX . 'post-thumbnail',
				'label'       => esc_html__( 'Show post featured image', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-share'] = array(
				'id'          => PREFIX . 'post-share',
				'label'       => esc_html__( 'Show post share', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);

		$options[PREFIX . 'post-footer-group'] = array(
			'id'          => PREFIX . 'post-footer-group',
			'label'       => esc_html__( 'Post Footer', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'post-tag'] = array(
				'id'          => PREFIX . 'post-tag',
				'label'       => esc_html__( 'Show post tags', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-nav'] = array(
				'id'          => PREFIX . 'post-nav',
				'label'       => esc_html__( 'Show post navigation', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'post-author-box'] = array(
				'id'          => PREFIX . 'post-author-box',
				'label'       => esc_html__( 'Show post author box', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);

		$options[PREFIX . 'related-posts-group'] = array(
			'id'          => PREFIX . 'related-posts-group',
			'label'       => esc_html__( 'Related Posts', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'related-posts'] = array(
				'id'          => PREFIX . 'related-posts',
				'label'       => esc_html__( 'Show related posts', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);
			$options[PREFIX . 'related-posts-title'] = array(
				'id'          => PREFIX . 'related-posts-title',
				'label'       => esc_html__( 'Related Posts Title', 'beginner' ),
				'section'     => $section,
				'type'        => 'text',
				'default'     => esc_html__( '<span>Recommended Posts</span> for You', 'beginner' )
			);
			$options[PREFIX . 'related-posts-img'] = array(
				'id'          => PREFIX . 'related-posts-img',
				'label'       => esc_html__( 'Show related posts thumbnail', 'beginner' ),
				'section'     => $section,
				'type'        => 'switch',
				'default'     => 1
			);

		// Page
		$section = PREFIX . 'page-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Page', 'beginner' ),
			'priority'    => 15,
			'panel'       => $content_panel
		);
		$options[PREFIX . 'page-title'] = array(
			'id'          => PREFIX . 'page-title',
			'label'       => esc_html__( 'Show page title', 'beginner' ),
			'section'     => $section,
			'type'        => 'switch',
			'default'     => 1
		);

	// Advertisement Panel and Sections
	$ads_panel = 'advertisement';

	$panels[] = array(
		'id'       => $ads_panel,
		'title'    => esc_html__( 'Advertisement', 'beginner' ),
		'priority' => 80
	);

		// Header ads
		$section = PREFIX . 'header-ads-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Header', 'beginner' ),
			'priority'    => 5,
			'panel'       => $ads_panel,
		);
		$options[PREFIX . 'header-ads-image'] = array(
			'id'           => PREFIX . 'header-ads-image',
			'label'        => esc_html__( 'Ads Image', 'beginner' ),
			'description'  => esc_html__( 'Upload your ads image then put the url in the setting below.', 'beginner' ),
			'section'      => $section,
			'type'         => 'media',
			'default'      => '',
		);
		$options[PREFIX . 'header-ads-url'] = array(
			'id'           => PREFIX . 'header-ads-url',
			'label'        => esc_html__( 'Ads URL', 'beginner' ),
			'description'  => esc_html__( 'Put the ads url in the box below.', 'beginner' ),
			'section'      => $section,
			'type'         => 'url',
			'default'      => ''
		);
		$options[PREFIX . 'header-ads-custom'] = array(
			'id'                => PREFIX . 'header-ads-custom',
			'label'             => esc_html__( 'Or', 'beginner' ),
			'description'       => esc_html__( 'Pur you custom ads code (eg. adsense) in the box below.', 'beginner' ),
			'section'           => $section,
			'type'              => 'textarea',
			'sanitize_callback' => 'beginner_textarea_stripslashes',
			'default'           => ''
		);

		// Posts ads
		$section = PREFIX . 'posts-ads-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Posts', 'beginner' ),
			'description' => esc_html__( 'Single post advertisement', 'beginner' ),
			'priority'    => 10,
			'panel'       => $ads_panel,
		);
		$options[PREFIX . 'post-ads-before'] = array(
			'id'          => PREFIX . 'post-ads-before',
			'label'       => esc_html__( 'Ads Before Content', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'post-ads-image-before'] = array(
				'id'           => PREFIX . 'post-ads-image-before',
				'label'        => esc_html__( 'Ads Image', 'beginner' ),
				'description'  => esc_html__( 'Upload your ads image then put the url in the setting below.', 'beginner' ),
				'section'      => $section,
				'type'         => 'media',
				'default'      => '',
			);
			$options[PREFIX . 'post-ads-url-before'] = array(
				'id'           => PREFIX . 'post-ads-url-before',
				'label'        => esc_html__( 'Ads URL', 'beginner' ),
				'description'  => esc_html__( 'Put the ads url in the box below.', 'beginner' ),
				'section'      => $section,
				'type'         => 'url',
				'default'      => ''
			);
			$options[PREFIX . 'post-ads-custom-before'] = array(
				'id'                => PREFIX . 'post-ads-custom-before',
				'label'             => esc_html__( 'Or', 'beginner' ),
				'description'       => esc_html__( 'Pur you custom ads code (eg. adsense) in the box below.', 'beginner' ),
				'section'           => $section,
				'type'              => 'textarea',
				'sanitize_callback' => 'beginner_textarea_stripslashes',
				'default'           => ''
			);
		$options[PREFIX . 'post-ads-after'] = array(
			'id'          => PREFIX . 'post-ads-after',
			'label'       => esc_html__( 'Ads After Content', 'beginner' ),
			'section'     => $section,
			'type'        => 'group-title'
		);
			$options[PREFIX . 'post-ads-image-after'] = array(
				'id'           => PREFIX . 'post-ads-image-after',
				'label'        => esc_html__( 'Ads Image', 'beginner' ),
				'description'  => esc_html__( 'Upload your ads image then put the url in the setting below.', 'beginner' ),
				'section'      => $section,
				'type'         => 'media',
				'default'      => '',
			);
			$options[PREFIX . 'post-ads-url-after'] = array(
				'id'           => PREFIX . 'post-ads-url-after',
				'label'        => esc_html__( 'Ads URL', 'beginner' ),
				'description'  => esc_html__( 'Put the ads url in the box below.', 'beginner' ),
				'section'      => $section,
				'type'         => 'url',
				'default'      => ''
			);
			$options[PREFIX . 'post-ads-custom-after'] = array(
				'id'                => PREFIX . 'post-ads-custom-after',
				'label'             => esc_html__( 'Or', 'beginner' ),
				'description'       => esc_html__( 'Pur you custom ads code (eg. adsense) in the box below.', 'beginner' ),
				'section'           => $section,
				'type'              => 'textarea',
				'sanitize_callback' => 'beginner_textarea_stripslashes',
				'default'           => ''
			);

	// only show if Deals plugin activated
	if ( is_tjdeals_activated() ) :

	// Deal Panel and Sections
	$deal_panel = 'deals';

	$panels[] = array(
		'id'          => $deal_panel,
		'title'       => esc_html__( 'Deals', 'beginner' ),
		'description' => esc_html__( 'This panel is used for managing several custom features/layouts of Deals in your site.', 'beginner' ),
		'priority'    => 90
	);

		// Featured deals
		$section = PREFIX . 'deals-featured-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Featured Deals', 'beginner' ),
			'priority'    => 10,
			'panel'       => $deal_panel
		);
			$options[PREFIX . 'featured-deals-select'] = array(
				'id'          => PREFIX . 'featured-deals-select',
				'label'       => esc_html__( 'Select a Deal Category', 'beginner' ),
				'section'     => $section,
				'type'        => 'select2',
				'choices'     => beginner_deals_cats_list()
			);
			$options[PREFIX . 'featured-deals-num'] = array(
				'id'          => PREFIX . 'featured-deals-num',
				'label'       => esc_html__( 'Number of deals', 'beginner' ),
				'section'     => $section,
				'type'        => 'text',
				'default'     => 3
			);
			$options[PREFIX . 'featured-deals-orderby'] = array(
				'id'          => PREFIX . 'featured-deals-orderby',
				'label'       => esc_html__( 'Order by', 'beginner' ),
				'section'     => $section,
				'type'        => 'select',
				'default'     => 'date',
				'choices'     => array(
					'date'       => esc_html__( 'Date', 'beginner' ),
					'rand'       => esc_html__( 'Random', 'beginner' ),
					'menu_order' => esc_html__( 'Custom', 'beginner' )
				)
			);
			$options[PREFIX . 'featured-deals-title'] = array(
				'id'          => PREFIX . 'featured-deals-title',
				'label'       => esc_html__( 'Featured Title', 'beginner' ),
				'section'     => $section,
				'type'        => 'text',
				'default'     => esc_html__( '<span>Featured</span> Deals & Discounts', 'beginner' )
			);
			$options[PREFIX . 'featured-deals-more'] = array(
				'id'          => PREFIX . 'featured-deals-more',
				'label'       => esc_html__( 'More Text', 'beginner' ),
				'section'     => $section,
				'type'        => 'text',
				'default'     => esc_html__( 'More Deals', 'beginner' )
			);
			$options[PREFIX . 'featured-deals-visibility'] = array(
				'id'          => PREFIX . 'featured-deals-visibility',
				'label'       => esc_html__( 'Visibility', 'beginner' ),
				'section'     => $section,
				'type'        => 'group-title'
			);
				$options[PREFIX . 'featured-deals-front'] = array(
					'id'          => PREFIX . 'featured-deals-front',
					'label'       => esc_html__( 'Show on Front page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 1
				);
				$options[PREFIX . 'featured-deals-home'] = array(
					'id'          => PREFIX . 'featured-deals-home',
					'label'       => esc_html__( 'Show on Home page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 1
				);
				$options[PREFIX . 'featured-deals-archive'] = array(
					'id'          => PREFIX . 'featured-deals-archive',
					'label'       => esc_html__( 'Show on Archive page', 'beginner' ),
					'description' => esc_html__( 'Blog, date, month and year page.', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-author'] = array(
					'id'          => PREFIX . 'featured-deals-author',
					'label'       => esc_html__( 'Show on Author page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-category'] = array(
					'id'          => PREFIX . 'featured-deals-category',
					'label'       => esc_html__( 'Show on Category page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-tag'] = array(
					'id'          => PREFIX . 'featured-deals-tag',
					'label'       => esc_html__( 'Show on Tag page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-search'] = array(
					'id'          => PREFIX . 'featured-deals-search',
					'label'       => esc_html__( 'Show on Search page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-404'] = array(
					'id'          => PREFIX . 'featured-deals-404',
					'label'       => esc_html__( 'Show on 404 page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-post'] = array(
					'id'          => PREFIX . 'featured-deals-post',
					'label'       => esc_html__( 'Show on Single Post', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);
				$options[PREFIX . 'featured-deals-page'] = array(
					'id'          => PREFIX . 'featured-deals-page',
					'label'       => esc_html__( 'Show on Single Page', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 0
				);

		// Archive deals
		$section = PREFIX . 'deals-archive-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Archive Deals', 'beginner' ),
			'priority'    => 20,
			'panel'       => $deal_panel
		);
			$options[PREFIX . 'deals-archive-title'] = array(
				'id'          => PREFIX . 'deals-archive-title',
				'label'       => esc_html__( 'Archive Deals Title', 'beginner' ),
				'section'     => $section,
				'type'        => 'text',
				'default'     => esc_html__( '<span>Deals & Discounts for</span> Bloggers', 'beginner' )
			);
			$options[PREFIX . 'deals-archive-desc'] = array(
				'id'      => PREFIX . 'deals-archive-desc',
				'label'   => esc_html__( 'Description', 'beginner' ),
				'section' => $section,
				'type'    => 'textarea',
				'default' => esc_html__( 'Collaboratively administrate empowered markets via plug-and-play networks. Dynamically procrastinate B2C users after installed base benefits. Dramatically visualize customer directed convergence without revolutionary ROI.', 'beginner' )
			);

		// Single deals
		$section = PREFIX . 'deals-single-section';

		$sections[] = array(
			'id'          => $section,
			'title'       => esc_html__( 'Single Deals', 'beginner' ),
			'priority'    => 30,
			'panel'       => $deal_panel
		);
			$options[PREFIX . 'related-deals-group'] = array(
				'id'          => PREFIX . 'related-deals-group',
				'label'       => esc_html__( 'Related Deals', 'beginner' ),
				'section'     => $section,
				'type'        => 'group-title'
			);
				$options[PREFIX . 'related-deals'] = array(
					'id'          => PREFIX . 'related-deals',
					'label'       => esc_html__( 'Show related deals', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 1
				);
				$options[PREFIX . 'related-deals-title'] = array(
					'id'          => PREFIX . 'related-deals-title',
					'label'       => esc_html__( 'Related Deals Title', 'beginner' ),
					'section'     => $section,
					'type'        => 'text',
					'default'     => esc_html__( '<span>More Amazing</span> Deals', 'beginner' )
				);
				$options[PREFIX . 'related-deals-img'] = array(
					'id'          => PREFIX . 'related-deals-img',
					'label'       => esc_html__( 'Show related deals thumbnail', 'beginner' ),
					'section'     => $section,
					'type'        => 'switch',
					'default'     => 1
				);

	endif; // end Deals section

	// Adds the sections to the $options array
	$options['sections'] = $sections;

	// Adds the panels to the $options array
	$options['panels'] = $panels;

	$customizer_library = Customizer_Library::Instance();
	$customizer_library->add_options( $options );

}
add_action( 'init', 'beginner_customizer_register' );

/**
 * Callback for Feedburner ID
 */
function beginner_newsletter_feedburner_callback( $control ) {
    if ( $control->manager->get_setting( PREFIX . 'newsletter-type' )->value() == 'feedburner' ) {
        return true;
    } else {
        return false;
    }
}

/**
 * Callback for Custom Code
 */
function beginner_newsletter_custom_callback( $control ) {
	if ( $control->manager->get_setting( PREFIX . 'newsletter-type' )->value() == 'custom' ) {
		return true;
	} else {
		return false;
	}
}
