<?php
/**
 * Admin functions for the plugin.
 *
 * @package    Theme_Junkie_Deals
 * @since      0.1.0
 * @author     Theme Junkie
 * @copyright  Copyright (c) 2016, Theme Junkie
 * @license    http://www.gnu.org/licenses/gpl-2.0.html
 */

/* Set up the admin functionality. */
add_action( 'admin_menu', 'tjd_admin_setup' );

/**
 * Plugin's admin functionality.
 *
 * @since  0.1.0
 * @access public
 */
function tjd_admin_setup() {

	/* Filter the 'enter title here' placeholder. */
	add_filter( 'enter_title_here', 'tjd_title_placeholder', 10 );

	/* Custom columns on the edit member screen. */
	add_filter( 'manage_edit-deal_columns', 'tjd_edit_deal_columns' );
	add_action( 'manage_deal_posts_custom_column', 'tjd_manage_deal_columns', 10, 2 );
	add_filter( 'manage_edit-deal_sortable_columns', 'tjd_column_sortable' );

}

/**
 * Filter the 'enter title here' placeholder.
 *
 * @param  string  $title
 * @since  0.1.0
 * @access public
 * @return string
 */
function tjd_title_placeholder( $title ) {

	if ( 'deal' == get_current_screen()->post_type )
		$title = esc_attr__( 'Enter deal title here', 'tjdeals' );
	
	return $title;
}

/**
 * Sets up custom columns on the deal edit screen.
 *
 * @param  array  $columns
 * @since  0.1.0
 * @access public
 * @return array
 */
function tjd_edit_deal_columns( $columns ) {

	unset( $columns['date'] );

	$columns['image']      = __( 'Image', 'tjdeals' );
	$columns['coupon']     = __( 'Coupon Code', 'tjdeals' );
	$columns['url']        = __( 'Destination URL', 'tjdeals' );
	$columns['menu_order'] = __( 'Order', 'tjdeals' );
	$columns['update']     = __( 'Last Update', 'tjdeals' );
	$columns['date']       = __( 'Published', 'tjdeals' );

	return $columns;
}

/**
 * Displays the content of custom deal columns on the edit screen.
 *
 * @param  string  $column
 * @param  int     $post_id
 * @since  0.1.0
 * @access public
 */
function tjd_manage_deal_columns( $column, $post_id ) {
	global $post;

	switch( $column ) {

		case 'image' :
			the_post_thumbnail( 'thumbnail' );
			break;

		case 'coupon' :
			if ( get_post_meta( $post_id, 'tjd_coupon_code', true ) )
				echo get_post_meta( $post->ID, 'tjd_coupon_code', true );
			break;

		case 'url' :
			if ( get_post_meta( $post->ID, 'tjd_custom_url', true ) )
				echo get_post_meta( $post->ID, 'tjd_custom_url', true );
			break;

		case 'menu_order':
			$order = $post->menu_order;
			echo $order;
			break;

		case 'update':
			echo get_the_modified_date( 'Y/m/d H:i' );
			break;

		/* Just break out of the switch statement for everything else. */
		default :
			break;
	}
}

/**
 * Make Order column sortable.
 * 
 * @since  0.1.0
 * @access public
 * @return object
 */
function tjd_column_sortable( $columns ) {
	$columns['menu_order'] = 'menu_order';
	return $columns;
}