<?php
/**
 * Customizing the post type messages.
 * 
 * @package    Theme_Junkie_Deals
 * @since      0.1.0
 * @author     Theme Junkie
 * @copyright  Copyright (c) 2016, Theme Junkie
 * @license    http://www.gnu.org/licenses/gpl-2.0.html
 */

/* Filter messages. */
add_filter( 'post_updated_messages', 'tjd_updated_messages' );

/**
 * Portfolio update messages.
 *
 * @param  array  $messages Existing post update messages.
 * @since  0.1.0
 * @access public
 * @return array  Amended post update messages with new CPT update messages.
 */
function tjd_updated_messages( $messages ) {
	global $post, $post_ID;

	$messages['deal'] = array(
		0 => '',
		1 => sprintf( __( 'Deal updated. <a href="%s">View Deal</a>', 'tjdeals' ), esc_url( get_permalink( $post_ID ) ) ),
		2 => __( 'Custom field updated.', 'tjdeals' ),
		3 => __( 'Custom field deleted.', 'tjdeals' ),
		4 => __( 'Deal updated.', 'tjdeals' ),
		5 => isset( $_GET['revision'] ) ? sprintf( __( 'Deal restored to revision from %s', 'tjdeals' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6 => sprintf( __( 'Deal published. <a href="%s">View It</a>', 'tjdeals' ), esc_url( get_permalink( $post_ID ) ) ),
		7 => __( 'Deal saved.', 'tjdeals' ),
		8 => sprintf( __( 'Deal submitted. <a target="_blank" href="%s">Preview Deal</a>', 'tjdeals' ), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
		9 => sprintf( __( 'Deal scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview Deal</a>', 'tjdeals' ),
		  // translators: Publish box date format, see http://php.net/date
		  date_i18n( __( 'M j, Y @ G:i', 'tjdeals' ), strtotime( $post->post_date ) ), esc_url( get_permalink( $post_ID ) ) ),
		10 => sprintf( __( 'Deal draft updated. <a target="_blank" href="%s">Preview Deal</a>', 'tjdeals' ), esc_url( add_query_arg( 'preview', 'true', get_permalink( $post_ID ) ) ) ),
	);

	return $messages;
}