<?php
/**
 * File for registering post type.
 *
 * @package    Deal_Junkie_Deals
 * @since      0.1.0
 * @author     Deal Junkie
 * @copyright  Copyright (c) 2016, Deal Junkie
 * @link       http://codex.wordpress.org/Function_Reference/register_post_type
 * @license    http://www.gnu.org/licenses/gpl-2.0.html
 */

/* Register custom post type on the 'init' hook. */
add_action( 'init', 'tjd_register_post_type' );

/**
 * Registers post type needed by the plugin.
 *
 * @since  0.1.0
 * @access public
 */
function tjd_register_post_type() {

	$labels = array(
	    'name'               => __( 'Deals', 'tjdeals' ),
	    'singular_name'      => __( 'Deal', 'tjdeals' ),
    	'menu_name'          => __( 'Deals', 'tjdeals' ),
    	'name_admin_bar'     => __( 'Deal', 'tjdeals' ),
		'all_items'          => __( 'Deals', 'tjdeals' ),
	    'add_new'            => __( 'Add New', 'tjdeals' ),
		'add_new_item'       => __( 'Add New Deal', 'tjdeals' ),
		'edit_item'          => __( 'Edit Deal', 'tjdeals' ),
		'new_item'           => __( 'New Deal', 'tjdeals' ),
		'view_item'          => __( 'View Deal', 'tjdeals' ),
		'search_items'       => __( 'Search Deals', 'tjdeals' ),
		'not_found'          => __( 'No Deals found', 'tjdeals' ),
		'not_found_in_trash' => __( 'No Deals found in trash', 'tjdeals' ),
		'parent_item_colon'  => '',
	);

	$defaults = array(	
		'labels'              => apply_filters( 'tjd_deal_labels', $labels ),
		'public'              => true,
		'exclude_from_search' => false,
		'menu_position'       => 50,
		'menu_icon'           => 'dashicons-tickets-alt',
		'supports'            => array( 'title', 'editor', 'revisions', 'page-attributes', 'thumbnail', 'excerpt' ),
		'rewrite'             => array( 'slug' => 'deal', 'with_front' => false ),
		'has_archive'         => true
	);

	$args = apply_filters( 'tjd_deal_args', $defaults );

	register_post_type( 'deal', $args );

}

/* Register custom taxonomy on the 'init' hook. */
add_action( 'init', 'tjd_register_deal_tax' );

/**
 * Register the taxonomy.
 */
function tjd_register_deal_tax() {

	$labels = array(
		'name'              => esc_html__( 'Deal Categories',        'tjdeals' ),
		'singular_name'     => esc_html__( 'Deal Category',          'tjdeals' ),
		'menu_name'         => esc_html__( 'Deal Categories',        'tjdeals' ),
		'all_items'         => esc_html__( 'All Deal Categories',    'tjdeals' ),
		'edit_item'         => esc_html__( 'Edit Deal Category',     'tjdeals' ),
		'view_item'         => esc_html__( 'View Deal Category',     'tjdeals' ),
		'update_item'       => esc_html__( 'Update Deal Category',   'tjdeals' ),
		'add_new_item'      => esc_html__( 'Add New Deal Category',  'tjdeals' ),
		'new_item_name'     => esc_html__( 'New Deal Category',      'tjdeals' ),
		'parent_item'       => esc_html__( 'Parent Deal Category',   'tjdeals' ),
		'parent_item_colon' => esc_html__( 'Parent Deal Category:',  'tjdeals' ),
		'search_items'      => esc_html__( 'Search Deal Categories', 'tjdeals' ),
	);

	$args = array(
		'labels'            => apply_filters( 'tjd_deal_category_tax_labels', $labels ),
		'hierarchical'      => true,
		'public'            => true,
		'show_ui'           => true,
		'show_in_nav_menus' => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'deal-category' ),
	);

	register_taxonomy( 'deal_category', 'deal', apply_filters( 'tjd_deal_category_tax_args', $args ) );

}