<?php

namespace BeycanPress\Walogin;

use BeycanPress\Walogin\Models\User;
use BeycanPress\Walogin\PluginHero\Plugin;

class Loader extends Plugin
{
    public function __construct($pluginFile)
    {
        parent::__construct([
            'pluginFile' => $pluginFile,
            'pluginKey' => 'walogin',
            'textDomain' => 'walogin',
            'settingKey' => 'walogin_settings',
            'pluginVersion' => '2.0.4'
        ]);
        
        new Services\Matching();
        new Services\LoginRegister();
        new Services\ConnectorModal();

        if ($this->setting('logoutRedirect')) {
            add_filter('logout_url', function($logoutUrl) {
                $redirectTo = $this->setting('logoutRedirect') == 'same-page' ? $this->getCurrentUrl() : $this->setting('logoutRedirect');
                return $logoutUrl . "&redirect_to=" . $redirectTo;
            });
        }

        add_action('wp_logout', function() {
            setcookie("wl-connected", "", (time() - 3600), '/', $_SERVER['HTTP_HOST']);
        });
    }

    public function adminProcess()
    {
        add_action('deleted_user', function($userId) {
            (new User())->delete([
                'userId' => $userId
            ]);
        });

        new Pages\UserList();

        if (in_array('walletconnect', Settings::getAcceptedWallets()) && $this->setting('infuraProjectId') == '') {
            $this->adminNotice(esc_html__('Please enter an infura project id for WalletConnect to work. - Walogin', 'cryptopay'), 'error');
        }
        
        add_action('init', function(){
            new Settings();
        }, 9);
    }

    public static function activation()
    {
        (new Models\User())->createTable();
    }

    public static function uninstall()
    {
        $settings = get_option(self::$instance->settingKey);
        if (isset($settings['dds']) && $settings['dds']) {
            delete_option(self::$instance->settingKey);
            (new Models\User())->drop();
        }
    }
}
