<?php

namespace BeycanPress\Walogin\Models;

use Beycan\Moodel\AbstractModel;

/**
 * User table model
 */
class User extends AbstractModel 
{
	public $version = '2';
	
	public $name = 'user_v2';
	
    public function __construct()
    {
        parent::__construct([
            'walletAddress' => [
                'type' => 'string',
                'length' => 70,
                'index' => [
                    'type' => 'unique'
                ]
            ],
            'userId' => [
                'type' => 'bigint',
            ],
            'loginSignature' => [
                'type' => 'text'
            ],
            'lastLoginDate' => [
                'type' => 'timestamp'
            ],
            'matchedDate' => [
                'type' => 'timestamp',
                'default' => 'current_timestamp',
            ],
        ]);
    }

    /**
     * @param string $text
     * @return string
     */
    public function search(string $text) : array
    {
        return $this->getResults(str_ireplace(
            '%s', 
            '%' . $this->db->esc_like($text) . '%', "
            SELECT * FROM {$this->tableName} 
            WHERE walletAddress LIKE '%s'
			ORDER BY id DESC
        "));
    }

    /**
     * @param string $text
     * @return string
     */
    public function searchCount(string $text) : int
    {
        return (int) $this->getVar(
            str_ireplace(
            '%s', 
            '%' . $this->db->esc_like($text) . '%', "
            SELECT COUNT(id) FROM {$this->tableName} 
            WHERE walletAddress LIKE '%s'
        "));
    }

}