<?php 

namespace BeycanPress\Walogin\Pages;

use Beycan\WPTable\Table;
use BeycanPress\Walogin\Models\User;
use BeycanPress\Walogin\PluginHero\Page;

/**
 * User list page
 */
class UserList extends Page
{   
    /**
     * Class construct
     * @return void
     */
    public function __construct()
    {
        parent::__construct([
            'pageName' => esc_html__('Walogin', 'walogin'),
            'subMenuPageName' => esc_html__('User list', 'walogin'),
            'subMenu' => true
        ]);
    }

    /**
     * @return void
     */
    public function page()
    {
        $user = new User();

        $table = (new Table($user))->setColumns( [
            'userId'         => esc_html__('User id', 'walogin'),
            'walletAddress'  => esc_html__('Wallet address', 'walogin'),
            'loginSignature' => esc_html__('Login signature', 'walogin'),
            'lastLoginDate'  => esc_html__('Last login date', 'walogin'),
            'matchedDate'    => esc_html__('Matched date', 'walogin'),
        ])
        ->setOrderQuery(['matchedDate', 'desc'])
        ->setOptions([
            'search' => [
                'id' => 'search-box',
                'title' => esc_html__('Search...', 'walogin')
            ]
        ])
        ->setSortableColumns([
            'matchedDate',
            'lastLoginDate'
        ])
        ->createDataList();

        $this->viewEcho('pages/user-list', [
            'table' => $table
        ]);
    }
}