<?php

namespace BeycanPress\Walogin\Services;

use BeycanPress\Walogin\Api;
use BeycanPress\Walogin\Lang;
use BeycanPress\Walogin\Settings;
use BeycanPress\Walogin\Models\User;
use BeycanPress\Walogin\PluginHero\Helpers;

class AbstractService
{
    use Helpers;

    protected $api;

    protected $loaded = false;

    /**
     * @return void
     */
    public function __construct()
    {
        $this->walletNames = Settings::getWalletNames();
        $this->acceptedWallets = Settings::getAcceptedWallets();
        $this->imagesUrl = $this->pluginUrl . 'assets/images/';
        $this->currentUser = (new User())->findOneBy(['userId' => get_current_user_id()]);
        $this->api = !$this->api ? new Api() : $this->api;
    }

    /**
     * @return void
     */
    protected function loadAssets()
    {
        if ($this->loaded == false) {
            $this->loaded = true;
            $this->addStyle('css/main.css');
            $this->addScript('js/multi-chain.min.js');
            $this->addScript('js/sweetalert2.js');
            $this->addScript('js/jquery.cookie-1.4.1.min.js', ['jquery']);
            $this->mainJsKey = $this->addScript('js/main.js', ['jquery']);
            wp_localize_script($this->mainJsKey, 'Walogin', [
                'lang' => Lang::get(),
                'acceptedWallets' => $this->acceptedWallets,
                'infuraId' => $this->setting('infuraProjectId'),
                'apiUrl' => $this->api->getUrl(),
            ]);
        }
    }
}