<?php

namespace BeycanPress\Walogin\Services;

class ConnectorModal extends AbstractService
{
    /**
     * @return void
     */
    public function __construct()
    {
        if (!is_admin()) {
            add_action('init', function() {
                parent::__construct();
                add_shortcode('walogin-connector-modal', [$this, 'connectorModal']);
            });
        }
    }

    /**
     * @return string
     */
    public function connectorModal() : string
    {
        $this->loadAssets();
        return $this->view('services/connector-modal');
    }

}