<?php

namespace BeycanPress\Walogin\Services;

class LoginRegister extends AbstractService
{
    /**
     * @return void
     */
    public function __construct()
    {
        if (!is_admin()) {
            if ($this->setting('wpLoginPage')) {
                add_action('login_form', [$this, 'loginButtonE']);
            }

            if ($this->setting('wcLoginPage')) {
                add_action('woocommerce_login_form', [$this, 'loginButtonE']);
            }
            
            add_action('init', function() {
                parent::__construct();
                add_shortcode('walogin-init', [$this, 'loginButton']);
            });
        }
    }

    /**
     * @return void
     */
    public function loginButtonE()
    {
        parent::__construct();
        echo $this->loginButton();
    }

    /**
     * @param array $atts 
     * @return string
     */
    public function loginButton($atts = []) : string
    {
        extract(shortcode_atts(array(
            'logout' => true,
        ), $atts));

        $logout = $logout === 'false' ? false : true;

        ob_start();

        if ($logout && !is_user_logged_in() || !$logout) {
            $this->loadAssets();
            $this->viewEcho('services/login-register');
        }
        
        if (is_user_logged_in() && $logout) {
            $currentUser = wp_get_current_user();
            printf(
                wp_kses(__( 'Hello, you are logged in as %s! (<a href="%s">Log out</a>)', 'walogin'), [
                    'a' => [
                        'href' => []
                    ]
                ]),
                '<strong>' . esc_html($currentUser->display_name) . '</strong>',
                esc_url(wp_logout_url())
            );
        }
        return ob_get_clean();
    }
}