<?php

namespace BeycanPress\Walogin\Services;

class Matching extends AbstractService
{
    /**
     * @return void
     */
    public function __construct()
    {
        if (!is_admin()) {
            add_action('init', function() {
                parent::__construct();
                add_shortcode('walogin-matching', [$this, 'matching']);
            });
        }
    }

    /**
     * @return string
     */
    public function matching() : string
    {
        if (is_user_logged_in()) {
            $this->loadAssets();

            return $this->view('services/matching');
        } else {
            return '';
        }
    }

}