<?php defined('ABSPATH') || exit;

/**
 * Plugin Name:  Walogin
 * Version:      2.0.4
 * Plugin URI:   https://walogin.beycanpress.com
 * Description:  Membership management with Blockchain (Authenticator)
 * Author URI:   https://beycanpress.com
 * Author:       BeycanPress
 * Tags:         Walogin, Login with crypto wallet for WordPress, Membership management with Blockchain, wallet, login, crypto, metamask, wordpress metamask login, ethereum login, binance smart chain login
 * Text Domain:  walogin
 * License:      GPLv3
 * License URI:  https://www.gnu.org/licenses/gpl-3.0.tr.html
 * Domain Path:  /languages
 * Requires at least: 5.0
 * Tested up to: 6.2
 * Requires PHP: 7.4
*/

add_action('admin_footer', function() {
	if (!get_option('cryptopay_new_version_promotionx')) {
    	update_option('cryptopay_new_version_promotionx', true);
        ?>
        <div class="cp-video-modal">
            <div class="modal-content">
                <div class="close-btn">
                    X
                </div>
                <div>
                    <iframe width="560" height="315" src="https://www.youtube.com/embed/3vaoFL4XG10" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                    <div class="buttons">
                        <a href="https://bit.ly/cplitebuynow" target="_blank" class="button"><?php echo __('Buy premium', 'cryptopay'); ?></a>
                        <a href="https://bit.ly/3pOiY25" target="_blank" class="button"><?php echo __('Review now', 'cryptopay'); ?></a>
                    </div>
                </div>
            </div>
        </div>
        <style>
            .cp-video-modal {
                position: fixed;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 999999;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .cp-video-modal .modal-content  {
                width: auto;
                max-width: 100%;
                padding: 40px;
                background-color: #fff;
                position: relative;
            }
            .cp-video-modal .modal-content .close-btn {
                position: absolute;
                right: 10px;
                top: 10px;
                cursor: pointer;
                font-weight: 600;
                font-size: 20px;
                color: #000;
            }
            .cp-video-modal .modal-content .buttons {
                position: relative;
                display: flex;
                justify-content: space-between;
                margin-top: 20px;
            }
            .cp-video-modal .modal-content iframe {
                max-width: 100%;
            }
        </style>
        <script>
            jQuery(document).ready(function($) {
                $('.cp-video-modal .close-btn').click(function() {
                    $('.cp-video-modal').hide();
                });
            });
        </script>
        <?php
	}
});
require __DIR__ . '/vendor/autoload.php';
new \BeycanPress\Walogin\Loader(__FILE__);